/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder.layout;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.WrappedTargetRuntimeException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.report.XFixedText;
import com.sun.star.report.XFormattedField;
import com.sun.star.report.XGroup;
import com.sun.star.report.XGroups;
import com.sun.star.report.XReportDefinition;
import com.sun.star.report.XSection;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.reportbuilder.layout.SectionEmptyObject;
import com.sun.star.wizards.reportbuilder.layout.SectionLabel;
import com.sun.star.wizards.reportbuilder.layout.SectionObject;
import com.sun.star.wizards.reportbuilder.layout.SectionTextField;

public class DesignTemplate {
    private XReportDefinition m_xReportDefinition;
    private SectionObject m_aDetailLabel;
    private SectionObject m_aDetailTextField;
    private SectionObject[] m_aGroupLabel;
    private SectionObject[] m_aGroupTextField;

    private DesignTemplate() {
    }

    XGroups getGroups() {
        return this.m_xReportDefinition.getGroups();
    }

    XSection getDetail() {
        return this.m_xReportDefinition.getDetail();
    }

    boolean getReportHeaderOn() {
        return this.m_xReportDefinition.getReportHeaderOn();
    }

    XSection getReportHeader() throws NoSuchElementException {
        return this.m_xReportDefinition.getReportHeader();
    }

    boolean getReportFooterOn() {
        return this.m_xReportDefinition.getReportFooterOn();
    }

    XSection getReportFooter() throws NoSuchElementException {
        return this.m_xReportDefinition.getReportFooter();
    }

    boolean getPageHeaderOn() {
        return this.m_xReportDefinition.getPageHeaderOn();
    }

    XSection getPageHeader() throws NoSuchElementException {
        return this.m_xReportDefinition.getPageHeader();
    }

    boolean getPageFooterOn() {
        return this.m_xReportDefinition.getPageFooterOn();
    }

    XSection getPageFooter() throws NoSuchElementException {
        return this.m_xReportDefinition.getPageFooter();
    }

    SectionObject getDetailLabel() {
        if (this.m_aDetailLabel == null) {
            return SectionEmptyObject.create();
        }
        return this.m_aDetailLabel;
    }

    SectionObject getDetailTextField() {
        if (this.m_aDetailTextField == null) {
            return SectionEmptyObject.create();
        }
        return this.m_aDetailTextField;
    }

    SectionObject getGroupTextField(int n) {
        return this.getGroupSectionObject(this.m_aGroupTextField, n);
    }

    SectionObject getGroupLabel(int n) {
        return this.getGroupSectionObject(this.m_aGroupLabel, n);
    }

    private SectionObject getGroupSectionObject(SectionObject[] sectionObjectArray, int n) {
        SectionObject sectionObject = null;
        if (n < sectionObjectArray.length) {
            sectionObject = sectionObjectArray[n];
        } else if (sectionObjectArray.length > 0) {
            sectionObject = sectionObjectArray[sectionObjectArray.length - 1];
        }
        if (sectionObject == null) {
            sectionObject = SectionEmptyObject.create();
            sectionObject.setPropertyValue("CharWeight", new Float(150.0f));
        }
        return sectionObject;
    }

    private void analyseReportDefinition() {
        Object object;
        XSection xSection = this.m_xReportDefinition.getDetail();
        int n = xSection.getCount();
        for (int i = 0; i < n; ++i) {
            try {
                Object object2 = xSection.getByIndex(i);
                XFixedText xFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)object2);
                if (xFixedText != null && this.m_aDetailLabel == null) {
                    this.m_aDetailLabel = SectionLabel.create(xFixedText);
                    continue;
                }
                object = (XFormattedField)UnoRuntime.queryInterface(XFormattedField.class, (Object)object2);
                if (object == null || this.m_aDetailTextField != null) continue;
                this.m_aDetailTextField = SectionTextField.create(object);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
        XGroups xGroups = this.m_xReportDefinition.getGroups();
        int n2 = xGroups.getCount();
        this.m_aGroupLabel = new SectionObject[n2];
        this.m_aGroupTextField = new SectionObject[n2];
        for (int i = 0; i < n2; ++i) {
            try {
                object = xGroups.getByIndex(i);
                XGroup xGroup = (XGroup)UnoRuntime.queryInterface(XGroup.class, (Object)object);
                XSection xSection2 = xGroup.getHeader();
                int n3 = xSection2.getCount();
                for (int j = 0; j < n3; ++j) {
                    try {
                        Object object3 = xSection2.getByIndex(j);
                        XFixedText xFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)object3);
                        if (xFixedText != null && this.m_aGroupLabel[i] == null) {
                            this.m_aGroupLabel[i] = SectionLabel.create(xFixedText);
                            continue;
                        }
                        XFormattedField xFormattedField = (XFormattedField)UnoRuntime.queryInterface(XFormattedField.class, (Object)object3);
                        if (xFormattedField == null || this.m_aGroupTextField[i] != null) continue;
                        this.m_aGroupTextField[i] = SectionTextField.create(xFormattedField);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        continue;
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
    }

    void close() {
        try {
            this.m_xReportDefinition.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            // empty catch block
        }
    }

    public static DesignTemplate create(XMultiServiceFactory xMultiServiceFactory, String string) {
        DesignTemplate designTemplate = new DesignTemplate();
        try {
            designTemplate.load(xMultiServiceFactory, string);
        }
        catch (WrappedTargetRuntimeException wrappedTargetRuntimeException) {
            designTemplate = null;
            throw new RuntimeException(wrappedTargetRuntimeException);
        }
        catch (com.sun.star.uno.Exception exception) {
            designTemplate = null;
        }
        catch (Exception exception) {
            designTemplate = null;
        }
        return designTemplate;
    }

    private void load(XMultiServiceFactory xMultiServiceFactory, String string) throws com.sun.star.uno.Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.report.ReportDefinition");
        this.m_xReportDefinition = (XReportDefinition)UnoRuntime.queryInterface(XReportDefinition.class, (Object)object);
        PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty((String)PropertyNames.URL, (Object)string), Properties.createProperty((String)PropertyNames.READ_ONLY, (Object)Boolean.TRUE)};
        this.m_xReportDefinition.load(propertyValueArray);
        this.analyseReportDefinition();
    }
}

