/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding.manual;

import java.util.Locale;
import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;

public final class Ascii
implements Encoding {
    @Override
    public String getName() {
        return "ASCII";
    }

    @Override
    public String getName(Locale locale) {
        return this.getName();
    }

    @Override
    public boolean isUnicodeCharacterSupported(int c) {
        return (c & 0xFFFFFF80) == 0;
    }

    @Override
    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new ByteBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        byte[] targetArray = buffer.getData();
        int[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            int sourceItem = sourceArray[i];
            if (!this.isUnicodeCharacterSupported(sourceItem)) continue;
            targetArray[targetIdx] = (byte)(sourceItem & 0x7F);
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    @Override
    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new CodePointBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        int[] targetArray = buffer.getData();
        byte[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            targetArray[targetIdx] = sourceArray[i] & 0x7F;
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    @Override
    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new ByteBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        byte[] targetArray = buffer.getData();
        int[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            int sourceItem = sourceArray[i];
            if (this.isUnicodeCharacterSupported(sourceItem)) {
                targetArray[targetIdx] = (byte)(sourceItem & 0x7F);
                ++targetIdx;
                continue;
            }
            if (EncodingErrorType.REPLACE.equals(errorHandling)) {
                targetArray[targetIdx] = 63;
                ++targetIdx;
                continue;
            }
            if (!EncodingErrorType.FAIL.equals(errorHandling)) continue;
            throw new EncodingException();
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    @Override
    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new CodePointBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        int[] targetArray = buffer.getData();
        byte[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            targetArray[targetIdx] = sourceArray[i] & 0x7F;
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }
}

