/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

public final class MagicArray {
    private final int[] data;
    private final int size;
    private long lastUpdatedKey = -1L;
    private int lastUpdatedValue;
    private long sum;
    private long maxSum;

    public MagicArray(int size) {
        this.data = new int[size];
        this.size = size;
    }

    public synchronized void incKey(long key) {
        this.incKey(key, 1);
    }

    public synchronized void incKey(long key, int delta) {
        if (key < this.lastUpdatedKey) {
            return;
        }
        if (key != this.lastUpdatedKey) {
            if (this.lastUpdatedKey != -1L) {
                this.setValue(this.lastUpdatedKey, this.lastUpdatedValue);
                for (long i = this.lastUpdatedKey + 1L; i < key; ++i) {
                    this.setValue(i, 0);
                }
            }
            this.lastUpdatedValue = 0;
            this.lastUpdatedKey = key;
        }
        this.lastUpdatedValue += delta;
    }

    private void setValue(long key, int value) {
        int i = (int)(key % (long)this.size);
        this.sum += (long)(value - this.data[i]);
        if (this.sum > this.maxSum) {
            this.maxSum = this.sum;
        }
        this.data[i] = value;
    }

    public synchronized long getSum() {
        return this.sum;
    }

    public synchronized long getMaxSum() {
        return this.maxSum;
    }

    private long getSumSlow() {
        long tmp = 0L;
        for (int d : this.data) {
            tmp += (long)d;
        }
        return tmp;
    }
}

