/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.GridPattern;
import org.stathissideris.ascii2image.text.GridPatternGroup;
import org.stathissideris.ascii2image.text.StringUtils;

public class TextGrid {
    private static final boolean DEBUG = false;
    private ArrayList<StringBuffer> rows;
    private static char[] boundaries = new char[]{'/', '\\', '|', '-', '*', '=', ':'};
    private static char[] undisputableBoundaries = new char[]{'|', '-', '*', '=', ':'};
    private static char[] horizontalLines = new char[]{'-', '='};
    private static char[] verticalLines = new char[]{'|', ':'};
    private static char[] arrowHeads = new char[]{'<', '>', '^', 'v', 'V'};
    private static char[] cornerChars = new char[]{'\\', '/', '+'};
    private static char[] pointMarkers = new char[]{'*'};
    private static char[] dashedLines = new char[]{':', '~', '='};
    private static char[] entryPoints1 = new char[]{'\\'};
    private static char[] entryPoints2 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints3 = new char[]{'/'};
    private static char[] entryPoints4 = new char[]{'-', '=', '+', '\\', '/'};
    private static char[] entryPoints5 = new char[]{'\\'};
    private static char[] entryPoints6 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints7 = new char[]{'/'};
    private static char[] entryPoints8 = new char[]{'-', '=', '+', '\\', '/'};
    private static HashMap<String, String> humanColorCodes = new HashMap();
    private static HashSet<String> markupTags;

    public void addToMarkupTags(Collection<String> tags) {
        markupTags.addAll(tags);
    }

    public static void main(String[] args) throws Exception {
        TextGrid grid = new TextGrid();
        grid.loadFrom("tests/text/art10.txt");
        TextGrid textGrid = grid;
        textGrid.getClass();
        grid.writeStringTo(textGrid.new Cell(28, 1), "testing");
        grid.findMarkupTags();
        grid.printDebug();
    }

    public TextGrid() {
        this.rows = new ArrayList();
    }

    public TextGrid(int width, int height) {
        String space = StringUtils.repeatString(" ", width);
        this.rows = new ArrayList();
        for (int i = 0; i < height; ++i) {
            this.rows.add(new StringBuffer(space));
        }
    }

    public static TextGrid makeSameSizeAs(TextGrid grid) {
        return new TextGrid(grid.getWidth(), grid.getHeight());
    }

    public TextGrid(TextGrid otherGrid) {
        this.rows = new ArrayList();
        for (StringBuffer row : otherGrid.getRows()) {
            this.rows.add(new StringBuffer(row));
        }
    }

    public void clear() {
        String blank = StringUtils.repeatString(" ", this.getWidth());
        int height = this.getHeight();
        this.rows.clear();
        for (int i = 0; i < height; ++i) {
            this.rows.add(new StringBuffer(blank));
        }
    }

    public char get(int x, int y) {
        if (x > this.getWidth() - 1 || y > this.getHeight() - 1 || x < 0 || y < 0) {
            return '\u0000';
        }
        return this.rows.get(y).charAt(x);
    }

    public char get(Cell cell) {
        if (cell.x > this.getWidth() - 1 || cell.y > this.getHeight() - 1 || cell.x < 0 || cell.y < 0) {
            return '\u0000';
        }
        return this.rows.get(cell.y).charAt(cell.x);
    }

    public StringBuffer getRow(int y) {
        return this.rows.get(y);
    }

    public TextGrid getSubGrid(int x, int y, int width, int height) {
        TextGrid grid = new TextGrid(width, height);
        for (int i = 0; i < height; ++i) {
            grid.setRow(i, new StringBuffer(this.getRow(y + i).subSequence(x, x + width)));
        }
        return grid;
    }

    public TextGrid getTestingSubGrid(Cell cell) {
        return this.getSubGrid(cell.x - 1, cell.y - 1, 3, 3);
    }

    public String getStringAt(int x, int y, int length) {
        return this.getStringAt(new Cell(x, y), length);
    }

    public String getStringAt(Cell cell, int length) {
        int x = cell.x;
        int y = cell.y;
        if (x > this.getWidth() - 1 || y > this.getHeight() - 1 || x < 0 || y < 0) {
            return null;
        }
        return this.rows.get(y).substring(x, x + length);
    }

    public char getNorthOf(int x, int y) {
        return this.get(x, y - 1);
    }

    public char getSouthOf(int x, int y) {
        return this.get(x, y + 1);
    }

    public char getEastOf(int x, int y) {
        return this.get(x + 1, y);
    }

    public char getWestOf(int x, int y) {
        return this.get(x - 1, y);
    }

    public char getNorthOf(Cell cell) {
        return this.getNorthOf(cell.x, cell.y);
    }

    public char getSouthOf(Cell cell) {
        return this.getSouthOf(cell.x, cell.y);
    }

    public char getEastOf(Cell cell) {
        return this.getEastOf(cell.x, cell.y);
    }

    public char getWestOf(Cell cell) {
        return this.getWestOf(cell.x, cell.y);
    }

    public void writeStringTo(int x, int y, String str) {
        this.writeStringTo(new Cell(x, y), str);
    }

    public void writeStringTo(Cell cell, String str) {
        if (this.isOutOfBounds(cell)) {
            return;
        }
        this.rows.get(cell.y).replace(cell.x, cell.x + str.length(), str);
    }

    public void set(Cell cell, char c) {
        this.set(cell.x, cell.y, c);
    }

    public void set(int x, int y, char c) {
        if (x > this.getWidth() - 1 || y > this.getHeight() - 1) {
            return;
        }
        StringBuffer row = this.rows.get(y);
        row.setCharAt(x, c);
    }

    public void setRow(int y, String row) {
        if (y > this.getHeight() || row.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(y, new StringBuffer(row));
    }

    public void setRow(int y, StringBuffer row) {
        if (y > this.getHeight() || row.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(y, row);
    }

    public int getWidth() {
        if (this.rows.size() == 0) {
            return 0;
        }
        return this.rows.get(0).length();
    }

    public int getHeight() {
        return this.rows.size();
    }

    public void printDebug() {
        Iterator<StringBuffer> it = this.rows.iterator();
        int i = 0;
        System.out.println("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1));
        while (it.hasNext()) {
            String row = it.next().toString();
            String index = new Integer(i).toString();
            if (i < 10) {
                index = " " + index;
            }
            System.out.println(index + " (" + row + ")");
            ++i;
        }
    }

    public String getDebugString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<StringBuffer> it = this.rows.iterator();
        int i = 0;
        buffer.append("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1) + "\n");
        while (it.hasNext()) {
            String row = it.next().toString();
            String index = new Integer(i).toString();
            if (i < 10) {
                index = " " + index;
            }
            row = row.replaceAll("\n", "\\\\n");
            row = row.replaceAll("\r", "\\\\r");
            buffer.append(index + " (" + row + ")\n");
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getDebugString();
    }

    public boolean add(TextGrid grid) {
        if (this.getWidth() != grid.getWidth() || this.getHeight() != grid.getHeight()) {
            return false;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                if (this.get(xi, yi) != ' ') continue;
                this.set(xi, yi, grid.get(xi, yi));
            }
        }
        return true;
    }

    public void replaceTypeOnLine() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                if (!Character.isLetterOrDigit(c)) continue;
                boolean isOnHorizontalLine = this.isOnHorizontalLine(xi, yi);
                boolean isOnVerticalLine = this.isOnVerticalLine(xi, yi);
                if (isOnHorizontalLine && isOnVerticalLine) {
                    this.set(xi, yi, '+');
                    continue;
                }
                if (isOnHorizontalLine) {
                    this.set(xi, yi, '-');
                    continue;
                }
                if (!isOnVerticalLine) continue;
                this.set(xi, yi, '|');
            }
        }
    }

    public void replacePointMarkersOnLine() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                Cell cell = new Cell(xi, yi);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(cell)) continue;
                boolean isOnHorizontalLine = false;
                if (StringUtils.isOneOf(this.get(cell.getEast()), horizontalLines)) {
                    isOnHorizontalLine = true;
                }
                if (StringUtils.isOneOf(this.get(cell.getWest()), horizontalLines)) {
                    isOnHorizontalLine = true;
                }
                boolean isOnVerticalLine = false;
                if (StringUtils.isOneOf(this.get(cell.getNorth()), verticalLines)) {
                    isOnVerticalLine = true;
                }
                if (StringUtils.isOneOf(this.get(cell.getSouth()), verticalLines)) {
                    isOnVerticalLine = true;
                }
                if (isOnHorizontalLine && isOnVerticalLine) {
                    this.set(xi, yi, '+');
                    continue;
                }
                if (isOnHorizontalLine) {
                    this.set(xi, yi, '-');
                    continue;
                }
                if (!isOnVerticalLine) continue;
                this.set(xi, yi, '|');
            }
        }
    }

    public CellSet getPointMarkersOnLine() {
        CellSet result = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(new Cell(xi, yi))) continue;
                result.add(new Cell(xi, yi));
            }
        }
        return result;
    }

    public void replaceHumanColorCodes() {
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            String row = this.rows.get(y).toString();
            for (String humanCode : humanColorCodes.keySet()) {
                String hexCode = humanColorCodes.get(humanCode);
                if (hexCode == null) continue;
                humanCode = "c" + humanCode;
                hexCode = "c" + hexCode;
                row = row.replaceAll(humanCode, hexCode);
                this.rows.set(y, new StringBuffer(row));
                row = this.rows.get(y).toString();
            }
        }
    }

    public void replaceAll(char c1, char c2) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                char c = this.get(xi, yi);
                if (c != c1) continue;
                this.set(xi, yi, c2);
            }
        }
    }

    public boolean hasBlankCells() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell = new Cell(x, y);
                if (!this.isBlank(cell)) continue;
                return true;
            }
        }
        return false;
    }

    public CellSet getAllNonBlank() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell = new Cell(x, y);
                if (this.isBlank(cell)) continue;
                set.add(cell);
            }
        }
        return set;
    }

    public CellSet getAllBoundaries() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell = new Cell(x, y);
                if (!this.isBoundary(cell)) continue;
                set.add(cell);
            }
        }
        return set;
    }

    public CellSet getAllBlanksBetweenCharacters() {
        CellSet set = new CellSet();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Cell cell = new Cell(x, y);
                if (!this.isBlankBetweenCharacters(cell)) continue;
                set.add(cell);
            }
        }
        return set;
    }

    public ArrayList<CellStringPair> findStrings() {
        ArrayList<CellStringPair> result = new ArrayList<CellStringPair>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (this.isBlank(x, y)) continue;
                Cell start = new Cell(x, y);
                String str = String.valueOf(this.get(x, y));
                char c = this.get(++x, y);
                boolean finished = false;
                while (!finished) {
                    str = str + String.valueOf(c);
                    c = this.get(++x, y);
                    char next = this.get(x + 1, y);
                    if (c != ' ' && c != '\u0000' || next != ' ' && next != '\u0000') continue;
                    finished = true;
                }
                result.add(new CellStringPair(start, str));
            }
        }
        return result;
    }

    public boolean hasEntryPoint(Cell cell, int entryPointId) {
        String result = "";
        char c = this.get(cell);
        if (entryPointId == 1) {
            return StringUtils.isOneOf(c, entryPoints1);
        }
        if (entryPointId == 2) {
            return StringUtils.isOneOf(c, entryPoints2);
        }
        if (entryPointId == 3) {
            return StringUtils.isOneOf(c, entryPoints3);
        }
        if (entryPointId == 4) {
            return StringUtils.isOneOf(c, entryPoints4);
        }
        if (entryPointId == 5) {
            return StringUtils.isOneOf(c, entryPoints5);
        }
        if (entryPointId == 6) {
            return StringUtils.isOneOf(c, entryPoints6);
        }
        if (entryPointId == 7) {
            return StringUtils.isOneOf(c, entryPoints7);
        }
        if (entryPointId == 8) {
            return StringUtils.isOneOf(c, entryPoints8);
        }
        return false;
    }

    public boolean isBlankBetweenCharacters(Cell cell) {
        return this.isBlank(cell) && !this.isBlank(cell.getEast()) && !this.isBlank(cell.getWest());
    }

    public void removeNonText() {
        this.removeArrowheads();
        this.removeColorCodes();
        this.removeBoundaries();
        this.removeMarkupTags();
    }

    public void removeArrowheads() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell = new Cell(xi, yi);
                if (!this.isArrowhead(cell)) continue;
                this.set(cell, ' ');
            }
        }
    }

    public void removeColorCodes() {
        Iterator<CellColorPair> cells = this.findColorCodes().iterator();
        while (cells.hasNext()) {
            Cell cell = cells.next().cell;
            this.set(cell, ' ');
            cell = cell.getEast();
            this.set(cell, ' ');
            cell = cell.getEast();
            this.set(cell, ' ');
            cell = cell.getEast();
            this.set(cell, ' ');
        }
    }

    public void removeBoundaries() {
        ArrayList<Cell> toBeRemoved = new ArrayList<Cell>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell = new Cell(xi, yi);
                if (!this.isBoundary(cell)) continue;
                toBeRemoved.add(cell);
            }
        }
        for (Cell cell : toBeRemoved) {
            this.set(cell, ' ');
        }
    }

    public ArrayList findArrowheads() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell = new Cell(xi, yi);
                if (!this.isArrowhead(cell)) continue;
                result.add(cell);
            }
        }
        return result;
    }

    public ArrayList<CellColorPair> findColorCodes() {
        Pattern colorCodePattern = Pattern.compile("c[A-F0-9]{3}");
        ArrayList<CellColorPair> result = new ArrayList<CellColorPair>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width - 3; ++xi) {
                Cell cell = new Cell(xi, yi);
                String s = this.getStringAt(cell, 4);
                Matcher matcher = colorCodePattern.matcher(s);
                if (!matcher.matches()) continue;
                char cR = s.charAt(1);
                char cG = s.charAt(2);
                char cB = s.charAt(3);
                int r = Integer.valueOf(String.valueOf(cR), 16) * 17;
                int g = Integer.valueOf(String.valueOf(cG), 16) * 17;
                int b = Integer.valueOf(String.valueOf(cB), 16) * 17;
                result.add(new CellColorPair(cell, new Color(r, g, b)));
            }
        }
        return result;
    }

    public ArrayList<CellTagPair> findMarkupTags() {
        Pattern tagPattern = Pattern.compile("\\{(.+?)\\}");
        ArrayList<CellTagPair> result = new ArrayList<CellTagPair>();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width - 3; ++x) {
                String tagName;
                String rowPart;
                Matcher matcher;
                Cell cell = new Cell(x, y);
                char c = this.get(cell);
                if (c != '{' || !(matcher = tagPattern.matcher(rowPart = this.rows.get(y).substring(x))).find() || !markupTags.contains(tagName = matcher.group(1))) continue;
                result.add(new CellTagPair(new Cell(x, y), tagName));
            }
        }
        return result;
    }

    public void removeMarkupTags() {
        for (CellTagPair pair3 : this.findMarkupTags()) {
            String tagName = pair3.tag;
            if (tagName == null) continue;
            int length = 2 + tagName.length();
            this.writeStringTo(pair3.cell, StringUtils.repeatString(" ", length));
        }
    }

    public boolean matchesAny(GridPatternGroup criteria) {
        return criteria.isAnyMatchedBy(this);
    }

    public boolean matchesAll(GridPatternGroup criteria) {
        return criteria.areAllMatchedBy(this);
    }

    public boolean matches(GridPattern criteria) {
        return criteria.isMatchedBy(this);
    }

    public boolean isOnHorizontalLine(Cell cell) {
        return this.isOnHorizontalLine(cell.x, cell.y);
    }

    private boolean isOnHorizontalLine(int x, int y) {
        char c1 = this.get(x - 1, y);
        char c2 = this.get(x + 1, y);
        return TextGrid.isHorizontalLine(c1) && TextGrid.isHorizontalLine(c2);
    }

    public boolean isOnVerticalLine(Cell cell) {
        return this.isOnVerticalLine(cell.x, cell.y);
    }

    private boolean isOnVerticalLine(int x, int y) {
        char c1 = this.get(x, y - 1);
        char c2 = this.get(x, y + 1);
        return TextGrid.isVerticalLine(c1) && TextGrid.isVerticalLine(c2);
    }

    public static boolean isBoundary(char c) {
        return StringUtils.isOneOf(c, boundaries);
    }

    public boolean isBoundary(int x, int y) {
        return this.isBoundary(new Cell(x, y));
    }

    public boolean isBoundary(Cell cell) {
        char c = this.get(cell.x, cell.y);
        if ('\u0000' == c) {
            return false;
        }
        if ('+' == c || '\\' == c || '/' == c) {
            return this.isIntersection(cell) || this.isCorner(cell) || this.isStub(cell) || this.isCrossOnLine(cell);
        }
        return StringUtils.isOneOf(c, boundaries) && !this.isLoneDiagonal(cell);
    }

    public boolean isLine(Cell cell) {
        return this.isHorizontalLine(cell) || this.isVerticalLine(cell);
    }

    public static boolean isHorizontalLine(char c) {
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public boolean isHorizontalLine(Cell cell) {
        return this.isHorizontalLine(cell.x, cell.y);
    }

    public boolean isHorizontalLine(int x, int y) {
        char c = this.get(x, y);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public static boolean isVerticalLine(char c) {
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isVerticalLine(Cell cell) {
        return this.isVerticalLine(cell.x, cell.y);
    }

    public boolean isVerticalLine(int x, int y) {
        char c = this.get(x, y);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isLinesEnd(int x, int y) {
        return this.isLinesEnd(new Cell(x, y));
    }

    public boolean isLinesEnd(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.linesEndCriteria);
    }

    public boolean isVerticalLinesEnd(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.verticalLinesEndCriteria);
    }

    public boolean isHorizontalLinesEnd(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.horizontalLinesEndCriteria);
    }

    public boolean isPointCell(Cell cell) {
        return this.isCorner(cell) || this.isIntersection(cell) || this.isStub(cell) || this.isLinesEnd(cell);
    }

    public boolean containsAtLeastOneDashedLine(CellSet set) {
        for (Cell cell : set) {
            if (!StringUtils.isOneOf(this.get(cell), dashedLines)) continue;
            return true;
        }
        return false;
    }

    public boolean exactlyOneNeighbourIsBoundary(Cell cell) {
        int howMany = 0;
        if (this.isBoundary(cell.getNorth())) {
            ++howMany;
        }
        if (this.isBoundary(cell.getSouth())) {
            ++howMany;
        }
        if (this.isBoundary(cell.getEast())) {
            ++howMany;
        }
        if (this.isBoundary(cell.getWest())) {
            ++howMany;
        }
        return howMany == 1;
    }

    public boolean isStub(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.stubCriteria);
    }

    public boolean isCrossOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.crossOnLineCriteria);
    }

    public boolean isHorizontalCrossOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.horizontalCrossOnLineCriteria);
    }

    public boolean isVerticalCrossOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.verticalCrossOnLineCriteria);
    }

    public boolean isStarOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.starOnLineCriteria);
    }

    public boolean isLoneDiagonal(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.loneDiagonalCriteria);
    }

    public boolean isHorizontalStarOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.horizontalStarOnLineCriteria);
    }

    public boolean isVerticalStarOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.verticalStarOnLineCriteria);
    }

    public boolean isArrowhead(Cell cell) {
        return this.isNorthArrowhead(cell) || this.isSouthArrowhead(cell) || this.isWestArrowhead(cell) || this.isEastArrowhead(cell);
    }

    public boolean isNorthArrowhead(Cell cell) {
        return this.get(cell) == '^';
    }

    public boolean isEastArrowhead(Cell cell) {
        return this.get(cell) == '>';
    }

    public boolean isWestArrowhead(Cell cell) {
        return this.get(cell) == '<';
    }

    public boolean isSouthArrowhead(Cell cell) {
        return (this.get(cell) == 'v' || this.get(cell) == 'V') && this.isVerticalLine(cell.getNorth());
    }

    public boolean isBullet(int x, int y) {
        return this.isBullet(new Cell(x, y));
    }

    public boolean isBullet(Cell cell) {
        char c = this.get(cell);
        return (c == 'o' || c == '*') && this.isBlank(cell.getEast()) && this.isBlank(cell.getWest()) && Character.isLetterOrDigit(this.get(cell.getEast().getEast()));
    }

    public void replaceBullets() {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int yi = 0; yi < height; ++yi) {
            for (int xi = 0; xi < width; ++xi) {
                Cell cell = new Cell(xi, yi);
                if (!this.isBullet(cell)) continue;
                this.set(cell, ' ');
                this.set(cell.getEast(), '\u2022');
            }
        }
    }

    public boolean isStringsStart(Cell cell) {
        return !this.isBlank(cell) && this.isBlank(cell.getWest());
    }

    public boolean isStringsEnd(Cell cell) {
        return !this.isBlank(cell) && this.isBlank(cell.getEast());
    }

    public int otherStringsStartInTheSameColumn(Cell cell) {
        if (!this.isStringsStart(cell)) {
            return 0;
        }
        int result = 0;
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            Cell cCell = new Cell(cell.x, y);
            if (cCell.equals(cell) || !this.isStringsStart(cCell)) continue;
            ++result;
        }
        return result;
    }

    public int otherStringsEndInTheSameColumn(Cell cell) {
        if (!this.isStringsEnd(cell)) {
            return 0;
        }
        int result = 0;
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            Cell cCell = new Cell(cell.x, y);
            if (cCell.equals(cell) || !this.isStringsEnd(cCell)) continue;
            ++result;
        }
        return result;
    }

    public boolean isColumnBlank(int x) {
        int height = this.getHeight();
        for (int y = 0; y < height; ++y) {
            if (this.isBlank(x, y)) continue;
            return false;
        }
        return true;
    }

    public CellSet followLine(int x, int y) {
        return this.followLine(new Cell(x, y));
    }

    public CellSet followIntersection(Cell cell) {
        return this.followIntersection(cell, null);
    }

    public CellSet followIntersection(Cell cell, Cell blocked) {
        if (!this.isIntersection(cell)) {
            return null;
        }
        CellSet result = new CellSet();
        Cell cN = cell.getNorth();
        Cell cS = cell.getSouth();
        Cell cE = cell.getEast();
        Cell cW = cell.getWest();
        if (this.hasEntryPoint(cN, 6)) {
            result.add(cN);
        }
        if (this.hasEntryPoint(cS, 2)) {
            result.add(cS);
        }
        if (this.hasEntryPoint(cE, 8)) {
            result.add(cE);
        }
        if (this.hasEntryPoint(cW, 4)) {
            result.add(cW);
        }
        if (result.contains(blocked)) {
            result.remove(blocked);
        }
        return result;
    }

    public CellSet followLine(Cell cell) {
        if (this.isHorizontalLine(cell)) {
            CellSet result = new CellSet();
            if (this.isBoundary(cell.getEast())) {
                result.add(cell.getEast());
            }
            if (this.isBoundary(cell.getWest())) {
                result.add(cell.getWest());
            }
            return result;
        }
        if (this.isVerticalLine(cell)) {
            CellSet result = new CellSet();
            if (this.isBoundary(cell.getNorth())) {
                result.add(cell.getNorth());
            }
            if (this.isBoundary(cell.getSouth())) {
                result.add(cell.getSouth());
            }
            return result;
        }
        return null;
    }

    public CellSet followLine(Cell cell, Cell blocked) {
        CellSet nextCells = this.followLine(cell);
        if (nextCells.contains(blocked)) {
            nextCells.remove(blocked);
        }
        return nextCells;
    }

    public CellSet followCorner(Cell cell) {
        return this.followCorner(cell, null);
    }

    public CellSet followCorner(Cell cell, Cell blocked) {
        if (!this.isCorner(cell)) {
            return null;
        }
        if (this.isCorner1(cell)) {
            return this.followCorner1(cell, blocked);
        }
        if (this.isCorner2(cell)) {
            return this.followCorner2(cell, blocked);
        }
        if (this.isCorner3(cell)) {
            return this.followCorner3(cell, blocked);
        }
        if (this.isCorner4(cell)) {
            return this.followCorner4(cell, blocked);
        }
        return null;
    }

    public CellSet followCorner1(Cell cell) {
        return this.followCorner1(cell, null);
    }

    public CellSet followCorner1(Cell cell, Cell blocked) {
        if (!this.isCorner1(cell)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell.getSouth().equals(blocked)) {
            result.add(cell.getSouth());
        }
        if (!cell.getEast().equals(blocked)) {
            result.add(cell.getEast());
        }
        return result;
    }

    public CellSet followCorner2(Cell cell) {
        return this.followCorner2(cell, null);
    }

    public CellSet followCorner2(Cell cell, Cell blocked) {
        if (!this.isCorner2(cell)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell.getSouth().equals(blocked)) {
            result.add(cell.getSouth());
        }
        if (!cell.getWest().equals(blocked)) {
            result.add(cell.getWest());
        }
        return result;
    }

    public CellSet followCorner3(Cell cell) {
        return this.followCorner3(cell, null);
    }

    public CellSet followCorner3(Cell cell, Cell blocked) {
        if (!this.isCorner3(cell)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell.getNorth().equals(blocked)) {
            result.add(cell.getNorth());
        }
        if (!cell.getWest().equals(blocked)) {
            result.add(cell.getWest());
        }
        return result;
    }

    public CellSet followCorner4(Cell cell) {
        return this.followCorner4(cell, null);
    }

    public CellSet followCorner4(Cell cell, Cell blocked) {
        if (!this.isCorner4(cell)) {
            return null;
        }
        CellSet result = new CellSet();
        if (!cell.getNorth().equals(blocked)) {
            result.add(cell.getNorth());
        }
        if (!cell.getEast().equals(blocked)) {
            result.add(cell.getEast());
        }
        return result;
    }

    public CellSet followStub(Cell cell) {
        return this.followStub(cell, null);
    }

    public CellSet followStub(Cell cell, Cell blocked) {
        if (!this.isStub(cell)) {
            return null;
        }
        CellSet result = new CellSet();
        if (this.isBoundary(cell.getEast())) {
            result.add(cell.getEast());
        } else if (this.isBoundary(cell.getWest())) {
            result.add(cell.getWest());
        } else if (this.isBoundary(cell.getNorth())) {
            result.add(cell.getNorth());
        } else if (this.isBoundary(cell.getSouth())) {
            result.add(cell.getSouth());
        }
        if (result.contains(blocked)) {
            result.remove(blocked);
        }
        return result;
    }

    public CellSet followCell(Cell cell) {
        return this.followCell(cell, null);
    }

    public CellSet followCell(Cell cell, Cell blocked) {
        if (this.isIntersection(cell)) {
            return this.followIntersection(cell, blocked);
        }
        if (this.isCorner(cell)) {
            return this.followCorner(cell, blocked);
        }
        if (this.isLine(cell)) {
            return this.followLine(cell, blocked);
        }
        if (this.isStub(cell)) {
            return this.followStub(cell, blocked);
        }
        if (this.isCrossOnLine(cell)) {
            return this.followCrossOnLine(cell, blocked);
        }
        System.err.println("Umbiguous input at position " + cell + ":");
        TextGrid subGrid = this.getTestingSubGrid(cell);
        subGrid.printDebug();
        throw new RuntimeException("Cannot follow cell " + cell + ": cannot determine cell type");
    }

    public String getCellTypeAsString(Cell cell) {
        if (this.isK(cell)) {
            return "K";
        }
        if (this.isT(cell)) {
            return "T";
        }
        if (this.isInverseK(cell)) {
            return "inverse K";
        }
        if (this.isInverseT(cell)) {
            return "inverse T";
        }
        if (this.isCorner1(cell)) {
            return "corner 1";
        }
        if (this.isCorner2(cell)) {
            return "corner 2";
        }
        if (this.isCorner3(cell)) {
            return "corner 3";
        }
        if (this.isCorner4(cell)) {
            return "corner 4";
        }
        if (this.isLine(cell)) {
            return "line";
        }
        if (this.isStub(cell)) {
            return "stub";
        }
        if (this.isCrossOnLine(cell)) {
            return "crossOnLine";
        }
        return "unrecognisable type";
    }

    public CellSet followCrossOnLine(Cell cell, Cell blocked) {
        CellSet result = new CellSet();
        if (this.isHorizontalCrossOnLine(cell)) {
            result.add(cell.getEast());
            result.add(cell.getWest());
        } else if (this.isVerticalCrossOnLine(cell)) {
            result.add(cell.getNorth());
            result.add(cell.getSouth());
        }
        if (result.contains(blocked)) {
            result.remove(blocked);
        }
        return result;
    }

    public boolean isOutOfBounds(Cell cell) {
        return cell.x > this.getWidth() - 1 || cell.y > this.getHeight() - 1 || cell.x < 0 || cell.y < 0;
    }

    public boolean isOutOfBounds(int x, int y) {
        char c = this.get(x, y);
        return '\u0000' == c;
    }

    public boolean isBlank(Cell cell) {
        char c = this.get(cell);
        if ('\u0000' == c) {
            return false;
        }
        return c == ' ';
    }

    public boolean isBlank(int x, int y) {
        char c = this.get(x, y);
        if ('\u0000' == c) {
            return true;
        }
        return c == ' ';
    }

    public boolean isCorner(Cell cell) {
        return this.isCorner(cell.x, cell.y);
    }

    public boolean isCorner(int x, int y) {
        return this.isNormalCorner(x, y) || this.isRoundCorner(x, y);
    }

    public boolean matchesAny(Cell cell, GridPatternGroup criteria) {
        TextGrid subGrid = this.getTestingSubGrid(cell);
        return subGrid.matchesAny(criteria);
    }

    public boolean isCorner1(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner1Criteria);
    }

    public boolean isCorner2(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner2Criteria);
    }

    public boolean isCorner3(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner3Criteria);
    }

    public boolean isCorner4(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner4Criteria);
    }

    public boolean isCross(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.crossCriteria);
    }

    public boolean isK(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.KCriteria);
    }

    public boolean isInverseK(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.inverseKCriteria);
    }

    public boolean isT(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.TCriteria);
    }

    public boolean isInverseT(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.inverseTCriteria);
    }

    public boolean isNormalCorner(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.normalCornerCriteria);
    }

    public boolean isNormalCorner(int x, int y) {
        return this.isNormalCorner(new Cell(x, y));
    }

    public boolean isRoundCorner(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.roundCornerCriteria);
    }

    public boolean isRoundCorner(int x, int y) {
        return this.isRoundCorner(new Cell(x, y));
    }

    public boolean isIntersection(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.intersectionCriteria);
    }

    public boolean isIntersection(int x, int y) {
        return this.isIntersection(new Cell(x, y));
    }

    public void copyCellsTo(CellSet cells, TextGrid grid) {
        for (Cell cell : cells) {
            grid.set(cell, this.get(cell));
        }
    }

    public boolean equals(TextGrid grid) {
        if (grid.getHeight() != this.getHeight() || grid.getWidth() != this.getWidth()) {
            return false;
        }
        int height = grid.getHeight();
        for (int i = 0; i < height; ++i) {
            String row2;
            String row1 = this.getRow(i).toString();
            if (row1.equals(row2 = grid.getRow(i).toString())) continue;
            return false;
        }
        return true;
    }

    public void fillCellsWith(Iterable cells, char c) {
        for (Cell cell : cells) {
            this.set(cell.x, cell.y, c);
        }
    }

    public CellSet fillContinuousArea(int x, int y, char c) {
        return this.fillContinuousArea(new Cell(x, y), c);
    }

    public CellSet fillContinuousArea(Cell cell, char c) {
        if (this.isOutOfBounds(cell)) {
            throw new IllegalArgumentException("Attempted to fill area out of bounds: " + cell);
        }
        return this.seedFillOld(cell, c);
    }

    private CellSet seedFill(Cell seed, char newChar) {
        CellSet cellsFilled = new CellSet();
        char oldChar = this.get(seed);
        if (oldChar == newChar) {
            return cellsFilled;
        }
        if (this.isOutOfBounds(seed)) {
            return cellsFilled;
        }
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(seed);
        while (!stack2.isEmpty()) {
            Cell cell = (Cell)stack2.pop();
            cellsFilled.add(cell);
            Cell nCell = cell.getNorth();
            Cell sCell = cell.getSouth();
            Cell eCell = cell.getEast();
            Cell wCell = cell.getWest();
            if (this.get(nCell) == oldChar && !cellsFilled.contains(nCell)) {
                stack2.push(nCell);
            }
            if (this.get(sCell) == oldChar && !cellsFilled.contains(sCell)) {
                stack2.push(sCell);
            }
            if (this.get(eCell) == oldChar && !cellsFilled.contains(eCell)) {
                stack2.push(eCell);
            }
            if (this.get(wCell) != oldChar || cellsFilled.contains(wCell)) continue;
            stack2.push(wCell);
        }
        return cellsFilled;
    }

    private CellSet seedFillOld(Cell seed, char newChar) {
        CellSet cellsFilled = new CellSet();
        char oldChar = this.get(seed);
        if (oldChar == newChar) {
            return cellsFilled;
        }
        if (this.isOutOfBounds(seed)) {
            return cellsFilled;
        }
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(seed);
        while (!stack2.isEmpty()) {
            Cell cell = (Cell)stack2.pop();
            this.set(cell, newChar);
            cellsFilled.add(cell);
            Cell nCell = cell.getNorth();
            Cell sCell = cell.getSouth();
            Cell eCell = cell.getEast();
            Cell wCell = cell.getWest();
            if (this.get(nCell) == oldChar) {
                stack2.push(nCell);
            }
            if (this.get(sCell) == oldChar) {
                stack2.push(sCell);
            }
            if (this.get(eCell) == oldChar) {
                stack2.push(eCell);
            }
            if (this.get(wCell) != oldChar) continue;
            stack2.push(wCell);
        }
        return cellsFilled;
    }

    public CellSet findBoundariesExpandingFrom(Cell seed) {
        CellSet boundaries = new CellSet();
        char oldChar = this.get(seed);
        if (this.isOutOfBounds(seed)) {
            return boundaries;
        }
        char newChar = '\u0001';
        Stack<Cell> stack2 = new Stack<Cell>();
        stack2.push(seed);
        while (!stack2.isEmpty()) {
            Cell cell = (Cell)stack2.pop();
            this.set(cell, newChar);
            Cell nCell = cell.getNorth();
            Cell sCell = cell.getSouth();
            Cell eCell = cell.getEast();
            Cell wCell = cell.getWest();
            if (this.get(nCell) == oldChar) {
                stack2.push(nCell);
            } else if (this.get(nCell) == '*') {
                boundaries.add(nCell);
            }
            if (this.get(sCell) == oldChar) {
                stack2.push(sCell);
            } else if (this.get(sCell) == '*') {
                boundaries.add(sCell);
            }
            if (this.get(eCell) == oldChar) {
                stack2.push(eCell);
            } else if (this.get(eCell) == '*') {
                boundaries.add(eCell);
            }
            if (this.get(wCell) == oldChar) {
                stack2.push(wCell);
                continue;
            }
            if (this.get(wCell) != '*') continue;
            boundaries.add(wCell);
        }
        return boundaries;
    }

    private CellSet seedFillLine(Cell cell, char newChar) {
        CellSet cellsFilled = new CellSet();
        Stack<LineSegment> stack2 = new Stack<LineSegment>();
        char oldChar = this.get(cell);
        if (oldChar == newChar) {
            return cellsFilled;
        }
        if (this.isOutOfBounds(cell)) {
            return cellsFilled;
        }
        stack2.push(new LineSegment(cell.x, cell.x, cell.y, 1));
        stack2.push(new LineSegment(cell.x, cell.x, cell.y + 1, -1));
        while (!stack2.isEmpty()) {
            boolean skip;
            int x;
            LineSegment segment = (LineSegment)stack2.pop();
            for (x = segment.x1; x >= 0 && this.get(x, segment.y) == oldChar; --x) {
                this.set(x, segment.y, newChar);
                cellsFilled.add(new Cell(x, segment.y));
            }
            int left = cell.getEast().x;
            boolean bl = skip = x > segment.x1;
            if (left < segment.x1) {
                stack2.push(new LineSegment(x, left, segment.y - 1, -segment.dy));
            }
            x = segment.x1 + 1;
            do {
                if (!skip) {
                    while (x < this.getWidth() && this.get(x, segment.y) == oldChar) {
                        this.set(x, segment.y, newChar);
                        cellsFilled.add(new Cell(x, segment.y));
                        ++x;
                    }
                    stack2.push(new LineSegment(left, x - 1, segment.y, segment.dy));
                    if (x > segment.x2 + 1) {
                        stack2.push(new LineSegment(segment.x2 + 1, x - 1, segment.y, -segment.dy));
                    }
                }
                skip = false;
                ++x;
                while (x <= segment.x2 && this.get(x, segment.y) != oldChar) {
                    ++x;
                }
                left = x;
            } while (x < segment.x2);
        }
        return cellsFilled;
    }

    public boolean cellContainsDashedLineChar(Cell cell) {
        char c = this.get(cell);
        return StringUtils.isOneOf(c, dashedLines);
    }

    public boolean loadFrom(String filename) throws FileNotFoundException, IOException {
        return this.loadFrom(filename, null);
    }

    public boolean loadFrom(String filename, ProcessingOptions options) throws IOException {
        String encoding = options == null ? null : options.getCharacterEncoding();
        ArrayList<StringBuffer> lines = new ArrayList<StringBuffer>();
        String[] linesArray = FileUtils.readFile(new File(filename), encoding).split("(\r)?\n");
        for (int i = 0; i < linesArray.length; ++i) {
            lines.add(new StringBuffer(linesArray[i]));
        }
        return this.initialiseWithLines(lines, options);
    }

    public boolean initialiseWithText(String text, ProcessingOptions options) throws UnsupportedEncodingException {
        ArrayList<StringBuffer> lines = new ArrayList<StringBuffer>();
        String[] linesArray = text.split("(\r)?\n");
        for (int i = 0; i < linesArray.length; ++i) {
            lines.add(new StringBuffer(linesArray[i]));
        }
        return this.initialiseWithLines(lines, options);
    }

    public boolean initialiseWithLines(ArrayList<StringBuffer> lines, ProcessingOptions options) throws UnsupportedEncodingException {
        boolean done = false;
        int i = lines.size() - 1;
        while (!done) {
            StringBuffer row = lines.get(i);
            if (!StringUtils.isBlank(row.toString())) {
                done = true;
            }
            --i;
        }
        this.rows = new ArrayList<StringBuffer>(lines.subList(0, i + 2));
        if (options != null) {
            this.fixTabs(options.getTabSize());
        } else {
            this.fixTabs(8);
        }
        int blankBorderSize = 2;
        int maxLength = 0;
        int index = 0;
        String encoding = null;
        Iterator<StringBuffer> it = this.rows.iterator();
        while (it.hasNext()) {
            String row = it.next().toString();
            if (encoding != null) {
                byte[] bytes = row.getBytes();
                row = new String(bytes, encoding);
            }
            if (row.length() > maxLength) {
                maxLength = row.length();
            }
            this.rows.set(index, new StringBuffer(row));
            ++index;
        }
        it = this.rows.iterator();
        ArrayList<StringBuffer> newRows = new ArrayList<StringBuffer>();
        StringBuffer topBottomRow = new StringBuffer(StringUtils.repeatString(" ", maxLength + blankBorderSize * 2));
        newRows.add(topBottomRow);
        newRows.add(topBottomRow);
        while (it.hasNext()) {
            StringBuffer row = it.next();
            if (row.length() < maxLength) {
                String borderString = StringUtils.repeatString(" ", blankBorderSize);
                StringBuffer newRow = new StringBuffer();
                newRow.append(borderString);
                newRow.append(row);
                newRow.append(StringUtils.repeatString(" ", maxLength - row.length()));
                newRow.append(borderString);
                newRows.add(newRow);
                continue;
            }
            newRows.add(new StringBuffer("  ").append(row).append("  "));
        }
        newRows.add(topBottomRow);
        newRows.add(topBottomRow);
        this.rows = newRows;
        this.replaceBullets();
        this.replaceHumanColorCodes();
        return true;
    }

    private void fixTabs(int tabSize) {
        int rowIndex = 0;
        Iterator<StringBuffer> it = this.rows.iterator();
        while (it.hasNext()) {
            String row = it.next().toString();
            StringBuffer newRow = new StringBuffer();
            char[] chars = row.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\t') {
                    int spacesLeft = tabSize - newRow.length() % tabSize;
                    String spaces = StringUtils.repeatString(" ", spacesLeft);
                    newRow.append(spaces);
                    continue;
                }
                String character = Character.toString(chars[i]);
                newRow.append(character);
            }
            this.rows.set(rowIndex, newRow);
            ++rowIndex;
        }
    }

    protected ArrayList<StringBuffer> getRows() {
        return this.rows;
    }

    static {
        humanColorCodes.put("GRE", "9D9");
        humanColorCodes.put("BLU", "55B");
        humanColorCodes.put("PNK", "FAA");
        humanColorCodes.put("RED", "E32");
        humanColorCodes.put("YEL", "FF3");
        humanColorCodes.put("BLK", "000");
        markupTags = new HashSet();
        markupTags.add("d");
        markupTags.add("s");
        markupTags.add("io");
        markupTags.add("c");
        markupTags.add("mo");
        markupTags.add("tr");
        markupTags.add("o");
    }

    private class LineSegment {
        int x1;
        int x2;
        int y;
        int dy;

        public LineSegment(int x1, int x2, int y, int dy) {
            this.x1 = x1;
            this.x2 = x2;
            this.y = y;
            this.dy = dy;
        }
    }

    public class Cell {
        public int x;
        public int y;

        public Cell(Cell cell) {
            this(cell.x, cell.y);
        }

        public Cell(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Cell getNorth() {
            return new Cell(this.x, this.y - 1);
        }

        public Cell getSouth() {
            return new Cell(this.x, this.y + 1);
        }

        public Cell getEast() {
            return new Cell(this.x + 1, this.y);
        }

        public Cell getWest() {
            return new Cell(this.x - 1, this.y);
        }

        public Cell getNW() {
            return new Cell(this.x - 1, this.y - 1);
        }

        public Cell getNE() {
            return new Cell(this.x + 1, this.y - 1);
        }

        public Cell getSW() {
            return new Cell(this.x - 1, this.y + 1);
        }

        public Cell getSE() {
            return new Cell(this.x + 1, this.y + 1);
        }

        public CellSet getNeighbours4() {
            CellSet result = new CellSet();
            result.add(this.getNorth());
            result.add(this.getSouth());
            result.add(this.getWest());
            result.add(this.getEast());
            return result;
        }

        public CellSet getNeighbours8() {
            CellSet result = new CellSet();
            result.add(this.getNorth());
            result.add(this.getSouth());
            result.add(this.getWest());
            result.add(this.getEast());
            result.add(this.getNW());
            result.add(this.getNE());
            result.add(this.getSW());
            result.add(this.getSE());
            return result;
        }

        public boolean isNorthOf(Cell cell) {
            return this.y < cell.y;
        }

        public boolean isSouthOf(Cell cell) {
            return this.y > cell.y;
        }

        public boolean isWestOf(Cell cell) {
            return this.x < cell.x;
        }

        public boolean isEastOf(Cell cell) {
            return this.x > cell.x;
        }

        public boolean equals(Object o) {
            Cell cell = (Cell)o;
            if (cell == null) {
                return false;
            }
            return this.x == cell.x && this.y == cell.y;
        }

        public int hashCode() {
            return this.x << 16 | this.y;
        }

        public boolean isNextTo(int x2, int y2) {
            if (Math.abs(x2 - this.x) == 1 && Math.abs(y2 - this.y) == 1) {
                return false;
            }
            if (Math.abs(x2 - this.x) == 1 && y2 == this.y) {
                return true;
            }
            return Math.abs(y2 - this.y) == 1 && x2 == this.x;
        }

        public boolean isNextTo(Cell cell) {
            if (cell == null) {
                throw new IllegalArgumentException("cell cannot be null");
            }
            return this.isNextTo(cell.x, cell.y);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }

        public void scale(int s) {
            this.x *= s;
            this.y *= s;
        }
    }

    public class CellTagPair {
        public Cell cell;
        public String tag;

        public CellTagPair(Cell cell, String tag) {
            this.cell = cell;
            this.tag = tag;
        }
    }

    public class CellStringPair {
        public Cell cell;
        public String string;

        public CellStringPair(Cell cell, String string) {
            this.cell = cell;
            this.string = string;
        }
    }

    public class CellColorPair {
        public Color color;
        public Cell cell;

        public CellColorPair(Cell cell, Color color) {
            this.cell = cell;
            this.color = color;
        }
    }
}

