/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;

public class CommandArrow3
extends SingleLineCommand2<ActivityDiagram3> {
    public static final String STYLE_COLORS = "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)\\]->";

    public CommandArrow3() {
        super(CommandArrow3.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr(new RegexLeaf("->"), new RegexLeaf("COLOR", STYLE_COLORS)), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("LABEL", "(.*);"), new RegexLeaf("")), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, RegexResult arg) {
        String label;
        String colorString = arg.get("COLOR", 0);
        if (colorString != null) {
            Rainbow rainbow = Rainbow.build(diagram.getSkinParam(), colorString, diagram.getSkinParam().colorArrowSeparationSpace());
            diagram.setColorNextArrow(rainbow);
        }
        if ((label = arg.get("LABEL", 0)) != null && label.length() > 0) {
            diagram.setLabelNextArrow(Display.getWithNewlines(label));
        }
        return CommandExecutionResult.ok();
    }
}

