/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileBreak;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Genealogy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileRepeat;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileFactoryDelegatorRepeat
extends FtileFactoryDelegator {
    public FtileFactoryDelegatorRepeat(FtileFactory factory) {
        super(factory);
    }

    @Override
    public Ftile repeat(Swimlane swimlane, Swimlane swimlaneOut, Display startLabel, Ftile repeat, Display test, Display yes, Display out, HtmlColor color, LinkRendering backRepeatLinkRendering, Ftile backward, boolean noOut) {
        ConditionStyle conditionStyle = this.skinParam().getConditionStyle();
        HtmlColor borderColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBorder);
        HtmlColor backColor = color == null ? this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBackground) : color;
        final Rainbow arrowColor = HtmlColorAndStyle.build(this.skinParam());
        LinkRendering endRepeatLinkRendering = repeat.getOutLinkRendering();
        Rainbow endRepeatLinkColor = endRepeatLinkRendering == null ? null : endRepeatLinkRendering.getRainbow();
        FontConfiguration fcDiamond = new FontConfiguration(this.skinParam(), FontParam.ACTIVITY_DIAMOND, null);
        FontConfiguration fcArrow = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        Ftile backStart = Display.isNull(startLabel) ? null : this.activity(startLabel, swimlane, BoxStyle.PLAIN, Colors.empty());
        Ftile result = FtileRepeat.create(backRepeatLinkRendering, swimlane, swimlaneOut, backStart, repeat, test, yes, out, borderColor, backColor, arrowColor, endRepeatLinkColor, conditionStyle, this.skinParam(), fcDiamond, fcArrow, backward, noOut);
        List<WeldingPoint> weldingPoints = repeat.getWeldingPoints();
        if (weldingPoints.size() > 0) {
            final FtileDiamond diamondBreak = new FtileDiamond(repeat.skinParam(), backColor, borderColor, swimlane);
            result = this.assembly(FtileUtils.addHorizontalMargin(result, 10.0, 0.0), diamondBreak);
            final Genealogy genealogy = new Genealogy(result);
            final FtileBreak ftileBreak = (FtileBreak)weldingPoints.get(0);
            result = FtileUtils.addConnection(result, new Connection(){

                @Override
                public void drawU(UGraphic ug) {
                    UTranslate tr1 = genealogy.getTranslate(ftileBreak, ug.getStringBounder());
                    UTranslate tr2 = genealogy.getTranslate(diamondBreak, ug.getStringBounder());
                    FtileGeometry dimDiamond = diamondBreak.calculateDimension(ug.getStringBounder());
                    Snake snake = new Snake(this.getFtile1().arrowHorizontalAlignment(), arrowColor, Arrows.asToRight());
                    snake.addPoint(tr1.getDx(), tr1.getDy());
                    snake.addPoint(0.0, tr1.getDy());
                    snake.addPoint(0.0, tr2.getDy() + ((Dimension2D)dimDiamond).getHeight() / 2.0);
                    snake.addPoint(tr2.getDx(), tr2.getDy() + ((Dimension2D)dimDiamond).getHeight() / 2.0);
                    ug.draw(snake);
                }

                @Override
                public Ftile getFtile1() {
                    return ftileBreak;
                }

                @Override
                public Ftile getFtile2() {
                    return diamondBreak;
                }
            });
        }
        return result;
    }
}

