/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.sourceforge.plantuml.code.Compression;

public class CompressionHuffman
implements Compression {
    @Override
    public byte[] compress(byte[] in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(2);
        deflater.setLevel(9);
        DeflaterOutputStream gz = new DeflaterOutputStream((OutputStream)baos, deflater);
        try {
            gz.write(in);
            gz.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    @Override
    public byte[] decompress(byte[] in) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        InflaterInputStream gz = new InflaterInputStream(bais);
        while ((read = gz.read()) != -1) {
            baos.write(read);
        }
        gz.close();
        bais.close();
        baos.close();
        return baos.toByteArray();
    }
}

