/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.command.CommandArrow;
import net.sourceforge.plantuml.sequencediagram.command.CommandExoArrowAny;

public class CommandExoArrowRight
extends CommandExoArrowAny {
    public CommandExoArrowRight() {
        super(CommandExoArrowRight.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PARALLEL", "(&%s*)?"), new RegexLeaf("PARTICIPANT", "([\\p{L}0-9_.@]+|[%g][^%g]+[%g])"), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW_SUPPCIRCLE", "([%s]+[ox])?"), new RegexOr(new RegexConcat(new RegexLeaf("ARROW_BOTHDRESSING", "(<<?|//?|\\\\\\\\?)?"), new RegexLeaf("ARROW_BODYA1", "(-+)"), new RegexLeaf("ARROW_STYLE1", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB1", "(-*)"), new RegexLeaf("ARROW_DRESSING1", "(>>?|//?|\\\\\\\\?)")), new RegexConcat(new RegexLeaf("ARROW_DRESSING2", "(<<?|//?|\\\\\\\\?)"), new RegexLeaf("ARROW_BODYB2", "(-*)"), new RegexLeaf("ARROW_STYLE2", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYA2", "(-+)"))), new RegexLeaf("SHORT", "([ox]?[?\\]\\[])?"), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL", "(?::[%s]*(.*))?"), new RegexLeaf("$"));
    }

    @Override
    MessageExoType getMessageExoType(RegexResult arg2) {
        String start = arg2.get("SHORT", 0);
        String dressing1 = arg2.get("ARROW_DRESSING1", 0);
        String dressing2 = arg2.get("ARROW_DRESSING2", 0);
        if (start != null && start.contains("[")) {
            if (dressing1 != null) {
                return MessageExoType.TO_LEFT;
            }
            if (dressing2 != null) {
                return MessageExoType.FROM_LEFT;
            }
            throw new IllegalArgumentException();
        }
        if (dressing1 != null) {
            return MessageExoType.TO_RIGHT;
        }
        if (dressing2 != null) {
            return MessageExoType.FROM_RIGHT;
        }
        throw new IllegalArgumentException();
    }
}

