/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.font.LineMetrics;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UText
implements UShape {
    private final String text;
    private final FontConfiguration font;
    private final String ariaLabel;

    public String toString() {
        return "UText[" + this.text + "]";
    }

    public UText(String text, FontConfiguration font) {
        this(text, font, null);
    }

    private UText(String text, FontConfiguration font, String ariaLabel) {
        assert (text.indexOf(9) == -1);
        this.text = text;
        this.font = font;
        this.ariaLabel = ariaLabel;
    }

    public UText withAriaLabel(String newAriaLabel) {
        return new UText(this.text, this.font, newAriaLabel);
    }

    public String getText() {
        return this.text;
    }

    public FontConfiguration getFontConfiguration() {
        return this.font;
    }

    public double getDescent() {
        LineMetrics fm = TextBlockUtils.getLineMetrics(this.font.getFont(), this.text);
        double descent = fm.getDescent();
        return descent;
    }

    public String getAriaLabel() {
        return this.ariaLabel;
    }
}

