/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import net.atmp.InnerStrategy;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.url.Url;

public class TextBlockWithUrl
implements TextBlock {
    private final TextBlock block;
    private final Url url;

    public static TextBlock withUrl(TextBlock block, Url url) {
        if (url == null) {
            return block;
        }
        return new TextBlockWithUrl(block, url);
    }

    private TextBlockWithUrl(TextBlock block, Url url) {
        this.block = block;
        this.url = url;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.startUrl(this.url);
        this.block.drawU(ug);
        ug.closeUrl();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.block.calculateDimension(stringBounder);
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        return this.block.getMinMax(stringBounder);
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.block.getInnerPosition(member, stringBounder, strategy);
    }

    @Override
    public MagneticBorder getMagneticBorder() {
        return this.block.getMagneticBorder();
    }

    @Override
    public HColor getBackcolor() {
        return this.block.getBackcolor();
    }
}

