/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.nwdiag.LinkedElement;
import net.sourceforge.plantuml.nwdiag.Network;

public class DiagGroup {
    private final String name;
    private final Network network;
    private final Set<String> elements = new HashSet<String>();
    private HtmlColor color;

    public String toString() {
        return this.name + " " + this.network + " " + this.elements;
    }

    public DiagGroup(String name, Network network) {
        this.name = name;
        this.network = network;
    }

    public final String getName() {
        return this.name;
    }

    public void addElement(String name) {
        this.elements.add(name);
    }

    public boolean matches(LinkedElement tested) {
        if (this.network != null && this.network != tested.getNetwork()) {
            return false;
        }
        return this.elements.contains(tested.getElement().getName());
    }

    public final HtmlColor getColor() {
        return this.color;
    }

    public final void setColor(HtmlColor color) {
        this.color = color;
    }
}

