/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.NetworkInterface;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Random;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.dedication.TurningBytes;

public class Magic {
    private final byte[] buffer = new byte[512];

    public String toString() {
        return SignatureUtils.toString(this.buffer);
    }

    public String toHexString() {
        return SignatureUtils.toHexString(this.buffer);
    }

    private void xor(TurningBytes turningBytes) {
        int i = 0;
        while (i < this.buffer.length) {
            int n = i++;
            this.buffer[n] = (byte)(this.buffer[n] ^ turningBytes.nextByte());
        }
    }

    public void xor(byte[] key) {
        this.xor(new TurningBytes(key));
    }

    public static Magic fromHexString(String s) {
        if (s.length() != 1024) {
            throw new IllegalArgumentException();
        }
        Magic result = new Magic();
        for (int i = 0; i < 512; ++i) {
            result.buffer[i] = (byte)(Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16) & 0xFF);
        }
        return result;
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }

    public void setByte(int pos, int data) {
        this.buffer[pos] = (byte)(0xFF & data);
    }

    public void setByte(byte[] shrink, int pos, int data) {
        this.buffer[pos] = (byte)(0xFF & (data ^ Magic.shrink(shrink)));
    }

    public int getByte(byte[] shrink, int pos) {
        return this.buffer[pos] ^ Magic.shrink(shrink);
    }

    public int getByte(int pos) {
        return this.buffer[pos];
    }

    public void set(int pos, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.buffer[pos + i] = data[i];
        }
    }

    public void setString(int pos, String s) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] tmp = s.getBytes("UTF-8");
        this.buffer[pos] = (byte)tmp.length;
        this.set(pos + 1, tmp);
    }

    public String getString(int pos) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte len = this.buffer[pos];
        if (len < 0 || len > 127) {
            throw new IllegalArgumentException();
        }
        String result = new String(this.get(pos + 1, len), "UTF-8");
        return result;
    }

    public byte[] get(int pos, int len) {
        byte[] result = new byte[len];
        System.arraycopy(this.buffer, pos, result, 0, len);
        return result;
    }

    private boolean isEquals(byte[] data1, byte[] data2) {
        if (data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] signature() throws IOException {
        String signature = OptionPrint.getHostName() + Magic.getMacAddress();
        try {
            return SignatureUtils.getSHA512raw(SignatureUtils.salting(signature, Magic.getSalt(signature)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    public static byte shrink(byte[] data) {
        byte result = 42;
        for (byte b : data) {
            result = (byte)(result ^ b);
        }
        return result;
    }

    public static byte[] getSalt(String signature) throws UnsupportedEncodingException {
        Random rnd = new Random(Magic.getSeed(signature.getBytes("UTF-8")));
        byte[] salt = new byte[512];
        rnd.nextBytes(salt);
        return salt;
    }

    private static long getSeed(byte[] bytes) {
        long result = 19L;
        for (byte b : bytes) {
            result = result * 41L + (long)b;
        }
        return result;
    }

    private static String getMacAddress() throws IOException {
        Enumeration<NetworkInterface> net = NetworkInterface.getNetworkInterfaces();
        StringBuilder result = new StringBuilder();
        while (net.hasMoreElements()) {
            NetworkInterface element = net.nextElement();
            byte[] mac = element.getHardwareAddress();
            if (mac == null) continue;
            for (byte b : mac) {
                result.append(String.format("%02x", b));
            }
        }
        return result.toString();
    }

    public static void main(String[] args) throws IOException {
        System.err.println(SignatureUtils.toHexString(Magic.signature()));
        System.out.println("Mac: " + Magic.getMacAddress());
    }
}

