/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.braille.BrailleCharFactory;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UFont;

public enum FileFormat {
    PNG,
    SVG,
    EPS,
    EPS_TEXT,
    ATXT,
    UTXT,
    XMI_STANDARD,
    XMI_STAR,
    XMI_ARGO,
    SCXML,
    PDF,
    MJPEG,
    ANIMATED_GIF,
    HTML,
    HTML5,
    VDX,
    LATEX,
    LATEX_NO_PREAMBLE,
    BASE64,
    BRAILLE_PNG,
    PREPROC;

    private static final BufferedImage imDummy;
    private static final Graphics2D gg;

    public String getFileSuffix() {
        if (this.name().startsWith("XMI")) {
            return ".xmi";
        }
        if (this == MJPEG) {
            return ".avi";
        }
        if (this == LATEX_NO_PREAMBLE) {
            return ".latex";
        }
        if (this == ANIMATED_GIF) {
            return ".gif";
        }
        if (this == BRAILLE_PNG) {
            return ".braille.png";
        }
        if (this == EPS_TEXT) {
            return EPS.getFileSuffix();
        }
        return "." + StringUtils.goLowerCase(this.name());
    }

    public StringBounder getDefaultStringBounder(TikzFontDistortion tikzFontDistortion) {
        if (this == LATEX || this == LATEX_NO_PREAMBLE) {
            return this.getTikzStringBounder(tikzFontDistortion);
        }
        if (this == BRAILLE_PNG) {
            return this.getBrailleStringBounder();
        }
        return this.getNormalStringBounder();
    }

    private StringBounder getNormalStringBounder() {
        return new StringBounder(){

            public String toString() {
                return "FileFormat::getNormalStringBounder";
            }

            @Override
            public Dimension2D calculateDimension(UFont font, String text) {
                return FileFormat.this.getJavaDimension(font, text);
            }
        };
    }

    private Dimension2DDouble getJavaDimension(UFont font, String text) {
        Font javaFont = font.getFont();
        FontMetrics fm = gg.getFontMetrics(javaFont);
        Rectangle2D rect = fm.getStringBounds(text, gg);
        return new Dimension2DDouble(rect.getWidth(), rect.getHeight());
    }

    private StringBounder getBrailleStringBounder() {
        return new StringBounder(){

            public String toString() {
                return "FileFormat::getBrailleStringBounder";
            }

            @Override
            public Dimension2D calculateDimension(UFont font, String text) {
                int nb = BrailleCharFactory.build(text).size();
                double quanta = 4.0;
                double height = 20.0;
                double width = (double)(3 * nb) * 4.0 + 1.0;
                return new Dimension2DDouble(width, 20.0);
            }
        };
    }

    private StringBounder getTikzStringBounder(final TikzFontDistortion tikzFontDistortion) {
        return new StringBounder(){

            public String toString() {
                return "FileFormat::getTikzStringBounder";
            }

            @Override
            public Dimension2D calculateDimension(UFont font, String text) {
                Dimension2DDouble w1 = FileFormat.this.getJavaDimension(font.goTikz(-1), text);
                Dimension2DDouble w2 = FileFormat.this.getJavaDimension(font.goTikz(0), text);
                Dimension2DDouble w3 = FileFormat.this.getJavaDimension(font.goTikz(1), text);
                double factor = (w3.getWidth() - w1.getWidth()) / w2.getWidth();
                double distortion = tikzFontDistortion.getDistortion();
                double magnify = tikzFontDistortion.getMagnify();
                double delta = (w2.getWidth() - w1.getWidth()) * factor * distortion;
                return w2.withWidth(Math.max(w1.getWidth(), magnify * w2.getWidth() - delta));
            }
        };
    }

    public boolean isEps() {
        if (this == EPS) {
            return true;
        }
        return this == EPS_TEXT;
    }

    public String changeName(String fileName, int cpt) {
        if (cpt == 0) {
            return this.changeName(fileName, this.getFileSuffix());
        }
        return this.changeName(fileName, OptionFlags.getInstance().getFileSeparator() + String.format("%03d", cpt) + this.getFileSuffix());
    }

    private File computeFilename(File pngFile, int i) {
        if (i == 0) {
            return pngFile;
        }
        File dir = pngFile.getParentFile();
        return new File(dir, this.computeFilenameInternal(pngFile.getName(), i));
    }

    private String changeName(String fileName, String replacement) {
        String result = fileName.replaceAll("\\.\\w+$", replacement);
        if (result.equals(fileName)) {
            result = fileName + replacement;
        }
        return result;
    }

    private String computeFilenameInternal(String name, int i) {
        if (i == 0) {
            return name;
        }
        return name.replaceAll("\\" + this.getFileSuffix() + "$", OptionFlags.getInstance().getFileSeparator() + String.format("%03d", i) + this.getFileSuffix());
    }

    static {
        imDummy = new BufferedImage(800, 100, 1);
        gg = imDummy.createGraphics();
    }
}

