/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ChangeState
implements Comparable<ChangeState> {
    private final TimeTick when;
    private final String state;
    private final String comment;
    private final Colors colors;

    public ChangeState(TimeTick when, String state, String comment, Colors colors) {
        this.when = when;
        this.state = state;
        this.comment = comment;
        this.colors = colors;
    }

    @Override
    public int compareTo(ChangeState other) {
        return this.when.compareTo(other.when);
    }

    public final TimeTick getWhen() {
        return this.when;
    }

    public final String getState() {
        return this.state;
    }

    public String getComment() {
        return this.comment;
    }

    private final HtmlColor getBackColor() {
        if (this.colors == null || this.colors.getColor(ColorType.BACK) == null) {
            return HtmlColorUtils.COL_D7E0F2;
        }
        return this.colors.getColor(ColorType.BACK);
    }

    private final HtmlColor getLineColor() {
        if (this.colors == null || this.colors.getColor(ColorType.LINE) == null) {
            return HtmlColorUtils.COL_038048;
        }
        return this.colors.getColor(ColorType.LINE);
    }

    public SymbolContext getContext() {
        return new SymbolContext(this.getBackColor(), this.getLineColor()).withStroke(new UStroke(1.5));
    }

    public final boolean isBlank() {
        return this.state.equals("{...}");
    }

    public final boolean isCompletelyHidden() {
        return this.state.equals("{hidden}");
    }
}

