/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.CommandChangeStateByPlayerCode;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimeTickBuilder;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandChangeStateByTime
extends SingleLineCommand2<TimingDiagram> {
    public CommandChangeStateByTime() {
        super(CommandChangeStateByTime.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("[%s]*"), TimeTickBuilder.expressionAtWithoutArobase("TIME"), new RegexLeaf("[%s]*is[%s]*"), CommandChangeStateByPlayerCode.getStateOrHidden(), new RegexLeaf("[%s]*"), CommandChangeStateByTime.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("COMMENT", "(?:[%s]*:[%s]*(.*?))?"), new RegexLeaf("[%s]*$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, RegexResult arg) {
        Player player = diagram.getLastPlayer();
        if (player == null) {
            return CommandExecutionResult.error("Missing @ line before this");
        }
        TimeTick tick = TimeTickBuilder.parseTimeTick("TIME", arg, diagram);
        String comment = arg.get("COMMENT", 0);
        Colors colors = CommandChangeStateByTime.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        player.setState(tick, arg.getLazzy("STATE", 0), comment, colors);
        diagram.addTime(tick);
        return CommandExecutionResult.ok();
    }
}

