/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.g2d;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverLineG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.DriverShadowedG2d;
import net.sourceforge.plantuml.klimt.drawing.g2d.ExtendedGeneralPath;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.USegment;
import net.sourceforge.plantuml.klimt.geom.USegmentType;

public class DriverPathG2d
extends DriverShadowedG2d
implements UDriver<UPath, Graphics2D> {
    private final double dpiFactor;

    public DriverPathG2d(double dpiFactor) {
        this.dpiFactor = dpiFactor;
    }

    @Override
    public void draw(UPath shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        DriverLineG2d.manageStroke(param, g2d);
        HColor back = param.getBackcolor();
        ExtendedGeneralPath p = new ExtendedGeneralPath();
        MinMax minMax = MinMax.getEmpty(false);
        minMax = minMax.addPoint(x, y);
        for (USegment seg : shape) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                p.moveTo(x + coord[0], y + coord[1]);
                minMax = minMax.addPoint(x + coord[0], y + coord[1]);
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                p.lineTo(x + coord[0], y + coord[1]);
                minMax = minMax.addPoint(x + coord[0], y + coord[1]);
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                p.curveTo(x + coord[0], y + coord[1], x + coord[2], y + coord[3], x + coord[4], y + coord[5]);
                minMax = minMax.addPoint(x + coord[4], y + coord[5]);
                continue;
            }
            if (type == USegmentType.SEG_ARCTO) {
                p.arcTo(coord[0], coord[1], coord[2], coord[3] != 0.0, coord[4] != 0.0, x + coord[5], y + coord[6]);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (shape.isOpenIconic()) {
            p.closePath();
            g2d.setColor(param.getColor().toColor(mapper));
            g2d.fill(p);
            return;
        }
        if (shape.getDeltaShadow() != 0.0) {
            if (back == null || back.isTransparent()) {
                this.drawOnlyLineShadowSpecial(g2d, p, shape.getDeltaShadow(), this.dpiFactor);
            } else {
                this.drawShadow(g2d, p, shape.getDeltaShadow(), this.dpiFactor);
            }
        }
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            char policy = gr.getPolicy();
            GradientPaint paint = policy == '|' ? new GradientPaint((float)minMax.getMinX(), (float)minMax.getMaxY() / 2.0f, gr.getColor1().toColor(mapper), (float)minMax.getMaxX(), (float)minMax.getMaxY() / 2.0f, gr.getColor2().toColor(mapper)) : (policy == '\\' ? new GradientPaint((float)minMax.getMinX(), (float)minMax.getMaxY(), gr.getColor1().toColor(mapper), (float)minMax.getMaxX(), (float)minMax.getMinY(), gr.getColor2().toColor(mapper)) : (policy == '-' ? new GradientPaint((float)minMax.getMaxX() / 2.0f, (float)minMax.getMinY(), gr.getColor1().toColor(mapper), (float)minMax.getMaxX() / 2.0f, (float)minMax.getMaxY(), gr.getColor2().toColor(mapper)) : new GradientPaint((float)x, (float)y, gr.getColor1().toColor(mapper), (float)minMax.getMaxX(), (float)minMax.getMaxY(), gr.getColor2().toColor(mapper))));
            g2d.setPaint(paint);
            g2d.fill(p);
        } else if (!back.isTransparent()) {
            g2d.setColor(back.toColor(mapper));
            g2d.fill(p);
        }
        if (!param.getColor().isTransparent()) {
            g2d.setColor(param.getColor().toColor(mapper));
            g2d.draw(p);
        }
    }
}

