/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.IFConstants;
import org.apache.fop.render.svg.SVGConstants;
import org.apache.fop.render.svg.SVGRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.uri.DataURLUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGDataUrlImageHandler
implements ImageHandler,
SVGConstants {
    private static final String CDATA = "CDATA";

    public int getPriority() {
        return 500;
    }

    public Class getSupportedImageClass() {
        return ImageRawStream.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{ImageFlavor.RAW_PNG, ImageFlavor.RAW_JPEG};
    }

    private void addAttribute(AttributesImpl atts, QName attribute, String value) {
        atts.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getQName(), CDATA, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        SVGRenderingContext svgContext = (SVGRenderingContext)context;
        if (!(image instanceof ImageRawStream)) {
            throw new IllegalStateException();
        }
        ImageRawStream raw = (ImageRawStream)image;
        InputStream in = raw.createInputStream();
        try {
            ContentHandler handler = svgContext.getContentHandler();
            String url = DataURLUtil.createDataURL((InputStream)in, (String)raw.getMimeType());
            AttributesImpl atts = new AttributesImpl();
            this.addAttribute(atts, IFConstants.XLINK_HREF, url);
            atts.addAttribute("", "x", "x", CDATA, Integer.toString(pos.x));
            atts.addAttribute("", "y", "y", CDATA, Integer.toString(pos.y));
            atts.addAttribute("", "width", "width", CDATA, Integer.toString(pos.width));
            atts.addAttribute("", "height", "height", CDATA, Integer.toString(pos.height));
            try {
                handler.startElement("http://www.w3.org/2000/svg", "image", "image", atts);
                handler.endElement("http://www.w3.org/2000/svg", "image", "image");
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        return (image == null || image instanceof ImageRawStream) && targetContext instanceof SVGRenderingContext;
    }
}

