/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.svek.GroupMakerActivity;
import net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierActivity {
    private final ICucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierActivity(ICucaDiagram diagram, List<String> dotStrings, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        do {
            changed = false;
            ArrayList<Entity> groups = new ArrayList<Entity>(diagram.getEntityFactory().groups());
            for (Entity g : groups) {
                if (!g.isAutarkic()) continue;
                IEntityImage img = this.computeImage(g);
                g.overrideImage(img, LeafType.ACTIVITY);
                changed = true;
            }
        } while (changed);
    }

    private IEntityImage computeImage(Entity g) throws IOException, InterruptedException {
        GroupMakerActivity maker = new GroupMakerActivity(this.diagram, g, this.stringBounder);
        return maker.getImage();
    }
}

