/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.geom;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.MinMaxMutable;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class MinMax {
    private final double maxX;
    private final double maxY;
    private final double minX;
    private final double minY;

    public boolean doesHorizontalCross(XPoint2D pt1, XPoint2D pt2) {
        if (pt1.getY() != pt2.getY()) {
            throw new IllegalArgumentException();
        }
        if (pt1.getX() == pt2.getX()) {
            throw new IllegalArgumentException();
        }
        double y = pt1.getY();
        if (y < this.minY || y > this.maxY) {
            return false;
        }
        if (pt1.getX() < this.minX && pt2.getX() > this.maxX) {
            return true;
        }
        return pt2.getX() < this.minX && pt1.getX() > this.maxX;
    }

    public static MinMax getEmpty(boolean initToZero) {
        if (initToZero) {
            return new MinMax(0.0, 0.0, 0.0, 0.0);
        }
        return new MinMax(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public String toString() {
        return "(" + this.minX + "," + this.minY + ")->(" + this.maxX + "," + this.maxY + ")";
    }

    public static MinMax fromMutable(MinMaxMutable minmax) {
        return new MinMax(minmax.getMinX(), minmax.getMinY(), minmax.getMaxX(), minmax.getMaxY());
    }

    private MinMax(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        if (Double.isNaN(minX)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(maxX)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(minY)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(maxY)) {
            throw new IllegalArgumentException();
        }
    }

    public MinMax addPoint(XPoint2D pt) {
        return this.addPoint(pt.getX(), pt.getY());
    }

    public MinMax addPoint(double x, double y) {
        return new MinMax(Math.min(x, this.minX), Math.min(y, this.minY), Math.max(x, this.maxX), Math.max(y, this.maxY));
    }

    public MinMax addMinMax(MinMax other) {
        return new MinMax(Math.min(other.minX, this.minX), Math.min(other.minY, this.minY), Math.max(other.maxX, this.maxX), Math.max(other.maxY, this.maxY));
    }

    public static MinMax fromMax(double maxX, double maxY) {
        return MinMax.getEmpty(true).addPoint(maxX, maxY);
    }

    public static MinMax fromDim(XDimension2D dim) {
        return MinMax.fromMax(dim.getWidth(), dim.getHeight());
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public XDimension2D getDimension() {
        return new XDimension2D(this.maxX - this.minX, this.maxY - this.minY);
    }

    public void drawGray(UGraphic ug) {
        this.draw(ug, HColors.GRAY);
    }

    public void draw(UGraphic ug, HColor color) {
        ug = ug.apply(color).apply(color.bg());
        ug = ug.apply(new UTranslate(this.minX, this.minY));
        ug.draw(URectangle.build(this.getWidth(), this.getHeight()));
    }

    public MinMax translate(UTranslate translate) {
        double dx = translate.getDx();
        double dy = translate.getDy();
        return new MinMax(this.minX + dx, this.minY + dy, this.maxX + dx, this.maxY + dy);
    }
}

