/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;

public enum MultilinesStrategy {
    REMOVE_STARTING_QUOTE,
    KEEP_STARTING_QUOTE;


    public void cleanList(List<? extends CharSequence> lines) {
        if (this == REMOVE_STARTING_QUOTE) {
            this.filterQuote(lines);
        }
    }

    private void filterQuote(List<? extends CharSequence> lines) {
        Iterator<? extends CharSequence> it = lines.iterator();
        while (it.hasNext()) {
            CharSequence s = it.next();
            if (!this.hasStartingQuote(s)) continue;
            it.remove();
        }
    }

    private boolean hasStartingQuote(CharSequence s) {
        return StringUtils.trinNoTrace(s).startsWith("'");
    }
}

