/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class USymbolFolder
extends USymbol {
    private static final int marginTitleX1 = 3;
    private static final int marginTitleX2 = 3;
    private static final int marginTitleX3 = 7;
    private static final int marginTitleY0 = 0;
    private static final int marginTitleY1 = 3;
    private static final int marginTitleY2 = 3;
    private final SkinParameter skinParameter;
    private final boolean showTitle;

    public USymbolFolder(SkinParameter skinParameter, boolean showTitle) {
        this.skinParameter = skinParameter;
        this.showTitle = showTitle;
    }

    @Override
    public SkinParameter getSkinParameter() {
        return this.skinParameter;
    }

    private void drawFolder(UGraphic ug, double width, double height, Dimension2D dimTitle, boolean shadowing, double roundCorner) {
        AbstractShadowable shape;
        double wtitle = dimTitle.getWidth() == 0.0 ? Math.max(30.0, width / 4.0) : dimTitle.getWidth() + 3.0 + 3.0;
        double htitle = this.getHTitle(dimTitle);
        if (roundCorner == 0.0) {
            UPolygon poly = new UPolygon();
            poly.addPoint(0.0, 0.0);
            poly.addPoint(wtitle, 0.0);
            poly.addPoint(wtitle + 7.0, htitle);
            poly.addPoint(width, htitle);
            poly.addPoint(width, height);
            poly.addPoint(0.0, height);
            poly.addPoint(0.0, 0.0);
            shape = poly;
        } else {
            UPath path = new UPath();
            path.moveTo(roundCorner / 2.0, 0.0);
            path.lineTo(wtitle - roundCorner / 2.0, 0.0);
            path.arcTo(new Point2D.Double(wtitle, roundCorner / 2.0), roundCorner / 2.0 * 1.5, 0.0, 1.0);
            path.lineTo(wtitle + 7.0, htitle);
            path.lineTo(width - roundCorner / 2.0, htitle);
            path.arcTo(new Point2D.Double(width, htitle + roundCorner / 2.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(width, height - roundCorner / 2.0);
            path.arcTo(new Point2D.Double(width - roundCorner / 2.0, height), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(roundCorner / 2.0, height);
            path.arcTo(new Point2D.Double(0.0, height - roundCorner / 2.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(0.0, roundCorner / 2.0);
            path.arcTo(new Point2D.Double(roundCorner / 2.0, 0.0), roundCorner / 2.0, 0.0, 1.0);
            path.closePath();
            shape = path;
        }
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.draw(shape);
        ug.apply(new UTranslate(0.0, htitle)).draw(new ULine(wtitle + 7.0, 0.0));
    }

    private double getHTitle(Dimension2D dimTitle) {
        double htitle = dimTitle.getWidth() == 0.0 ? 10.0 : dimTitle.getHeight() + 3.0 + 3.0;
        return htitle;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 20.0, 13.0, 10.0);
    }

    @Override
    public TextBlock asSmall(final TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, USymbolFolder.this.getRectangleStencil(dim), new UStroke());
                ug = symbolContext.apply(ug);
                Dimension2D dimName = USymbolFolder.this.showTitle ? name.calculateDimension(ug.getStringBounder()) : new Dimension2DDouble(40.0, 15.0);
                USymbolFolder.this.drawFolder(ug, dim.getWidth(), dim.getHeight(), dimName, symbolContext.isShadowing(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolFolder.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                if (USymbolFolder.this.showTitle) {
                    name.drawU(ug.apply(new UTranslate(4.0, 3.0)));
                }
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1() + dimName.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimName = name.calculateDimension(stringBounder);
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolFolder.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimName, dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                Dimension2D dim = this.calculateDimension(stringBounder);
                ug = symbolContext.apply(ug);
                Dimension2D dimTitle = title.calculateDimension(stringBounder);
                USymbolFolder.this.drawFolder(ug, dim.getWidth(), dim.getHeight(), dimTitle, symbolContext.isShadowing(), symbolContext.getRoundCorner());
                title.drawU(ug.apply(new UTranslate(4.0, 2.0)));
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(4.0 + posStereo, 2.0 + USymbolFolder.this.getHTitle(dimTitle))));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }
}

