/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementClose;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.ComplementInColors2;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.DaysAsDates;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

public class VerbIsOrAre
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementClose(), new ComplementInColors2());
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("(is|are)");
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                if (complement instanceof ComplementColors) {
                    HtmlColor color = ((ComplementColors)complement).getCenter();
                    return VerbIsOrAre.this.manageColor(project, subject, color);
                }
                return VerbIsOrAre.this.manageClose(project, subject);
            }
        };
    }

    private CommandExecutionResult manageColor(GanttDiagram project, Subject subject, HtmlColor color) {
        if (subject instanceof DayAsDate) {
            DayAsDate day = (DayAsDate)subject;
            project.colorDay(day, color);
        }
        if (subject instanceof DaysAsDates) {
            DaysAsDates days = (DaysAsDates)subject;
            for (DayAsDate d : days) {
                project.colorDay(d, color);
            }
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult manageClose(GanttDiagram project, Subject subject) {
        if (subject instanceof DayAsDate) {
            DayAsDate day = (DayAsDate)subject;
            project.closeDayAsDate(day);
        }
        if (subject instanceof DaysAsDates) {
            DaysAsDates days = (DaysAsDates)subject;
            for (DayAsDate d : days) {
                project.closeDayAsDate(d);
            }
        }
        return CommandExecutionResult.ok();
    }
}

