/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.graphic.StringBounder;

public class FileFormatOption
implements Serializable {
    private final FileFormat fileFormat;
    private final AffineTransform affineTransform;
    private boolean withMetadata;
    private final boolean useRedForError;
    private final String svgLinkTarget;
    private final String hoverColor;
    private final TikzFontDistortion tikzFontDistortion;
    private boolean debugsvek = false;

    public FileFormatOption(FileFormat fileFormat) {
        this(fileFormat, null, true, false, "_top", false, null, TikzFontDistortion.getDefault());
    }

    public StringBounder getDefaultStringBounder() {
        return this.fileFormat.getDefaultStringBounder(this.tikzFontDistortion);
    }

    public String getSvgLinkTarget() {
        return this.svgLinkTarget;
    }

    public final boolean isWithMetadata() {
        return this.withMetadata;
    }

    public FileFormatOption(FileFormat fileFormat, boolean withMetadata) {
        this(fileFormat, null, false, false, "_top", false, null, TikzFontDistortion.getDefault());
    }

    private FileFormatOption(FileFormat fileFormat, AffineTransform at, boolean withMetadata, boolean useRedForError, String svgLinkTarget, boolean debugsvek, String hoverColor, TikzFontDistortion tikzFontDistortion) {
        this.hoverColor = hoverColor;
        this.fileFormat = fileFormat;
        this.affineTransform = at;
        this.withMetadata = withMetadata;
        this.useRedForError = useRedForError;
        this.svgLinkTarget = svgLinkTarget;
        this.debugsvek = debugsvek;
        this.tikzFontDistortion = tikzFontDistortion;
        if (tikzFontDistortion == null) {
            throw new IllegalArgumentException();
        }
    }

    public FileFormatOption withUseRedForError() {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, true, this.svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion);
    }

    public FileFormatOption withTikzFontDistortion(TikzFontDistortion tikzFontDistortion) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, true, this.svgLinkTarget, this.debugsvek, this.hoverColor, tikzFontDistortion);
    }

    public FileFormatOption withSvgLinkTarget(String svgLinkTarget) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, svgLinkTarget, this.debugsvek, this.hoverColor, this.tikzFontDistortion);
    }

    public FileFormatOption withHoverColor(String hoverColor) {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, this.useRedForError, this.svgLinkTarget, this.debugsvek, hoverColor, this.tikzFontDistortion);
    }

    public String toString() {
        return this.fileFormat.toString() + " " + this.affineTransform;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public final boolean isUseRedForError() {
        return this.useRedForError;
    }

    public void setDebugSvek(boolean debugsvek) {
        this.debugsvek = debugsvek;
    }

    public boolean isDebugSvek() {
        return this.debugsvek;
    }

    public final String getHoverColor() {
        return this.hoverColor;
    }

    public void hideMetadata() {
        this.withMetadata = false;
    }

    public final TikzFontDistortion getTikzFontDistortion() {
        return this.tikzFontDistortion;
    }
}

