/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowConfiguration;

public class MessageExo
extends AbstractMessage {
    private final MessageExoType type;
    private final Participant participant;
    private final boolean shortArrow;

    public MessageExo(Participant p, MessageExoType type, Display label, ArrowConfiguration arrowConfiguration, String messageNumber, boolean shortArrow) {
        super(label, arrowConfiguration, messageNumber);
        this.participant = p;
        this.type = type;
        this.shortArrow = shortArrow;
    }

    public boolean isShortArrow() {
        return this.shortArrow;
    }

    @Override
    protected NotePosition overideNotePosition(NotePosition notePosition) {
        if (this.type == MessageExoType.FROM_LEFT || this.type == MessageExoType.TO_LEFT) {
            return NotePosition.RIGHT;
        }
        if (this.type == MessageExoType.FROM_RIGHT || this.type == MessageExoType.TO_RIGHT) {
            return NotePosition.LEFT;
        }
        throw new IllegalStateException();
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public final MessageExoType getType() {
        return this.type;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.participant == someone;
    }

    @Override
    public boolean compatibleForCreate(Participant p) {
        return p == this.participant;
    }

    @Override
    public boolean isSelfMessage() {
        return false;
    }
}

