/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockHorizontal
extends AbstractTextBlock
implements TextBlock {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final VerticalAlignment alignment;

    TextBlockHorizontal(TextBlock b1, TextBlock b2, VerticalAlignment alignment) {
        this.blocks.add(b1);
        this.blocks.add(b2);
        this.alignment = alignment;
    }

    public TextBlockHorizontal(List<TextBlock> all, VerticalAlignment alignment) {
        if (all.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(all);
        this.alignment = alignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dim = Dimension2DDouble.mergeLR(dim, this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        Dimension2D dimtotal = this.calculateDimension(ug.getStringBounder());
        for (TextBlock block : this.blocks) {
            Dimension2D dimb = block.calculateDimension(ug.getStringBounder());
            if (this.alignment == VerticalAlignment.CENTER) {
                double dy = (dimtotal.getHeight() - dimb.getHeight()) / 2.0;
                block.drawU(ug.apply(new UTranslate(x, dy)));
            } else {
                block.drawU(ug.apply(new UTranslate(x, 0.0)));
            }
            x += dimb.getWidth();
        }
    }
}

