/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class AtomWithMargin
implements Atom {
    private final double marginY1;
    private final double marginY2;
    private final Atom atom;

    public AtomWithMargin(Atom atom, double marginY1, double marginY2) {
        this.atom = atom;
        this.marginY1 = marginY1;
        this.marginY2 = marginY2;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.atom.calculateDimension(stringBounder), 0.0, this.marginY1 + this.marginY2);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.atom.getStartingAltitude(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.atom.drawU(ug.apply(new UTranslate(0.0, this.marginY1)));
    }
}

