/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.atmp.PixelImage;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.eggs.QuoteUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.klimt.AffineTransformType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.GraphicPosition;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

public class GraphvizCrash
extends AbstractTextBlock
implements IEntityImage {
    private final TextBlock text1;
    private final String text;
    private final BufferedImage flashCode;
    private final boolean graphviz244onWindows;

    public GraphvizCrash(String text, boolean graphviz244onWindows, Throwable rootCause) {
        this.text = text;
        this.graphviz244onWindows = graphviz244onWindows;
        this.flashCode = FlashCodeFactory.getFlashCodeUtils().exportFlashcode(text, Color.BLACK, Color.WHITE);
        this.text1 = GraphicStrings.createBlackOnWhite(this.init(rootCause), IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    public static List<String> anErrorHasOccured(Throwable exception, String text) {
        ArrayList<String> strings = new ArrayList<String>();
        if (exception == null) {
            strings.add("An error has occured!");
        } else {
            strings.add("An error has occured : " + exception);
        }
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        strings.add("Diagram size: " + GraphvizCrash.lines(text) + " lines / " + text.length() + " characters.");
        strings.add(" ");
        return strings;
    }

    private static int lines(String text) {
        int result = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    public static void checkOldVersionWarning(List<String> strings) {
        long days = (System.currentTimeMillis() - Version.compileTime()) / 1000L / 3600L / 24L;
        if (days >= 90L) {
            strings.add(" ");
            strings.add("<b>This version of PlantUML is " + days + " days old, so you should");
            strings.add("<b>consider upgrading from https://plantuml.com/download");
        }
    }

    public static void pleaseGoTo(List<String> strings) {
        strings.add(" ");
        strings.add("Please go to https://plantuml.com/graphviz-dot to check your GraphViz version.");
        strings.add(" ");
    }

    public static void youShouldSendThisDiagram(List<String> strings) {
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>https://plantuml.com/qa</b> to solve this issue.");
        strings.add("You can try to turn around this issue by simplifing your diagram.");
    }

    public static void thisMayBeCaused(List<String> strings) {
        strings.add("This may be caused by :");
        strings.add(" - a bug in PlantUML");
        strings.add(" - a problem in GraphViz");
    }

    private List<String> init(Throwable rootCause) {
        List<String> strings = GraphvizCrash.anErrorHasOccured(null, this.text);
        strings.add("For some reason, dot/GraphViz has crashed.");
        strings.add("");
        strings.add("RootCause " + rootCause);
        if (rootCause != null) {
            strings.addAll(CommandExecutionResult.getStackTrace(rootCause));
        }
        strings.add("");
        strings.add("This has been generated with PlantUML (" + Version.versionString() + ").");
        GraphvizCrash.checkOldVersionWarning(strings);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        try {
            String dotVersion = GraphvizUtils.dotVersion();
            strings.add("Default dot version: " + dotVersion);
        }
        catch (Throwable e) {
            strings.add("Cannot determine dot version: " + e.toString());
        }
        GraphvizCrash.pleaseGoTo(strings);
        GraphvizCrash.youShouldSendThisDiagram(strings);
        if (this.flashCode != null) {
            GraphvizCrash.addDecodeHint(strings);
        }
        return strings;
    }

    private List<String> getText2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(" ");
        strings.add("<b>It looks like you are running GraphViz 2.44 under Windows.");
        strings.add("If you have just installed GraphViz, you <i>may</i> have to execute");
        strings.add("the post-install command <b>dot -c</b> like in the following example:");
        return strings;
    }

    private List<String> getText3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(" ");
        strings.add("You may have to have <i>Administrator rights</i> to avoid the following error message:");
        return strings;
    }

    public static void addDecodeHint(List<String> strings) {
        strings.add(" ");
        strings.add(" Diagram source: (Use http://zxing.org/w/decode.jspx to decode the qrcode)");
    }

    public static void addProperties(List<String> strings) {
        strings.addAll(OptionPrint.interestingProperties());
        strings.addAll(OptionPrint.interestingValues());
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public HColor getBackcolor() {
        return HColors.WHITE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getMain().calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getMain().drawU(ug);
    }

    private TextBlock getMain() {
        TextBlock result = this.text1;
        if (this.flashCode != null) {
            UImage flash = new UImage(new PixelImage(this.flashCode, AffineTransformType.TYPE_NEAREST_NEIGHBOR)).scale(3.0);
            result = TextBlockUtils.mergeTB(result, flash, HorizontalAlignment.LEFT);
        }
        if (this.graphviz244onWindows) {
            TextBlock text2 = GraphicStrings.createBlackOnWhite(this.getText2());
            result = TextBlockUtils.mergeTB(result, text2, HorizontalAlignment.LEFT);
            UImage dotc = new UImage(new PixelImage(PSystemVersion.getDotc(), AffineTransformType.TYPE_BILINEAR));
            result = TextBlockUtils.mergeTB(result, dotc, HorizontalAlignment.LEFT);
            TextBlock text3 = GraphicStrings.createBlackOnWhite(this.getText3());
            result = TextBlockUtils.mergeTB(result, text3, HorizontalAlignment.LEFT);
            UImage dotd = new UImage(new PixelImage(PSystemVersion.getDotd(), AffineTransformType.TYPE_BILINEAR));
            result = TextBlockUtils.mergeTB(result, dotd, HorizontalAlignment.LEFT);
        }
        return result;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

