/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.Resource;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ResourceDraw
implements UDrawable {
    private final Resource res;
    private final TimeScale timeScale;
    private final double y;
    private final Instant min;
    private final Instant max;
    private final GanttDiagram gantt;

    public ResourceDraw(GanttDiagram gantt, Resource res, TimeScale timeScale, double y, Instant min, Instant max) {
        this.res = res;
        this.timeScale = timeScale;
        this.y = y;
        this.min = min;
        this.max = max;
        this.gantt = gantt;
    }

    @Override
    public void drawU(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.res.getName()).create(this.getFontConfiguration(13), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        title.drawU(ug);
        ULine line = new ULine(this.timeScale.getEndingPosition(this.max) - this.timeScale.getStartingPosition(this.min), 0.0);
        ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UTranslate(0.0, title.calculateDimension(ug.getStringBounder()).getHeight())).draw(line);
        Instant i = this.min;
        while (i.compareTo(this.max) <= 0) {
            int load = this.gantt.getLoadForResource(this.res, i);
            if (load > 0) {
                FontConfiguration fontConfiguration = this.getFontConfiguration(9, load > 100 ? HtmlColorUtils.RED : HtmlColorUtils.BLACK);
                TextBlock value = Display.getWithNewlines("" + load).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                double start = (this.timeScale.getStartingPosition(i) + this.timeScale.getEndingPosition(i)) / 2.0 - value.calculateDimension(ug.getStringBounder()).getWidth() / 2.0;
                value.drawU(ug.apply(new UTranslate(start, 16.0)));
            }
            i = i.increment();
        }
    }

    private FontConfiguration getFontConfiguration(int size) {
        return this.getFontConfiguration(size, HtmlColorUtils.BLACK);
    }

    private FontConfiguration getFontConfiguration(int size, HtmlColor color) {
        UFont font = UFont.serif(size);
        return new FontConfiguration(font, color, color, false);
    }

    public double getHeight() {
        return 32.0;
    }

    public double getY() {
        return this.y;
    }
}

