/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;

public class ComponentTextDelay
extends AbstractComponentText {
    private final Display stringsToDisplay;

    public ComponentTextDelay(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.stringsToDisplay = stringsToDisplay;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int textWidth = StringUtils.getWcWidth(this.stringsToDisplay);
        int textPos = (width - textWidth) / 2;
        if (this.stringsToDisplay.isWhite()) {
            return;
        }
        String desc = this.stringsToDisplay.get(0).toString();
        charArea.drawStringLR(desc, textPos, 1);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 4;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 2;
    }
}

