/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flowdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.flowdiagram.FlowDiagram;
import net.sourceforge.plantuml.golem.TileGeometry;

public class CommandLink
extends SingleLineCommand2<FlowDiagram> {
    public CommandLink() {
        super(CommandLink.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("ORIENTATION", "(?:([nsew])[%s]+)?"), new RegexLeaf("ID_DEST", "(\\w+)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(FlowDiagram system, RegexResult arg) {
        String idDest = arg.get("ID_DEST", 0);
        String orientationString = arg.get("ORIENTATION", 0);
        TileGeometry orientation = TileGeometry.SOUTH;
        if (orientationString != null) {
            orientation = TileGeometry.fromString(orientationString);
        }
        system.linkSimple(orientation, idDest);
        return CommandExecutionResult.ok();
    }
}

