/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.comp;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import net.sourceforge.plantuml.ugraphic.comp.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.comp.SlotFinder;
import net.sourceforge.plantuml.ugraphic.comp.SlotSet;
import net.sourceforge.plantuml.ugraphic.comp.UGraphicCompressOnXorY;

public class TextBlockCompressedOnXorY
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final CompressionMode mode;
    private MinMax cachedMinMax;
    private CompressionTransform cachedCompressionTransform;

    public TextBlockCompressedOnXorY(CompressionMode mode, TextBlock textBlock) {
        this.textBlock = textBlock;
        this.mode = mode;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        CompressionTransform compressionTransform = this.getCompressionTransform(stringBounder);
        this.textBlock.drawU(new UGraphicCompressOnXorY(this.mode, ug, compressionTransform));
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        if (this.cachedMinMax == null) {
            this.cachedMinMax = TextBlockUtils.getMinMax(this, stringBounder);
        }
        return this.cachedMinMax;
    }

    private CompressionTransform getCompressionTransform(StringBounder stringBounder) {
        if (this.cachedCompressionTransform == null) {
            this.cachedCompressionTransform = this.getCompressionTransformSlow(stringBounder);
        }
        return this.cachedCompressionTransform;
    }

    private CompressionTransform getCompressionTransformSlow(StringBounder stringBounder) {
        SlotFinder slotFinder = new SlotFinder(this.mode, stringBounder);
        this.textBlock.drawU(slotFinder);
        SlotSet ysSlotSet = slotFinder.getSlotSet().reverse().smaller(5.0);
        CompressionTransform compressionTransform = new CompressionTransform(ysSlotSet);
        return compressionTransform;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        CompressionTransform compressionTransform = this.getCompressionTransform(stringBounder);
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        if (this.mode == CompressionMode.ON_X) {
            return new Dimension2DDouble(compressionTransform.transform(dim.getWidth()), dim.getHeight());
        }
        return new Dimension2DDouble(dim.getWidth(), compressionTransform.transform(dim.getHeight()));
    }
}

