/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;

public class FileSystem {
    private static final FileSystem singleton = new FileSystem();
    private final ThreadLocal<File> currentDir = new ThreadLocal();

    private FileSystem() {
        this.reset();
    }

    public static FileSystem getInstance() {
        return singleton;
    }

    public void setCurrentDir(File dir) {
        Log.info("Setting current dir: " + dir);
        this.currentDir.set(dir);
    }

    public File getCurrentDir() {
        return this.currentDir.get();
    }

    public File getFile(String nameOrPath) throws IOException {
        File file;
        File dir = this.currentDir.get();
        if (dir == null || this.isAbsolute(nameOrPath)) {
            return new File(nameOrPath).getCanonicalFile();
        }
        File filecurrent = new File(dir.getAbsoluteFile(), nameOrPath);
        if (filecurrent.exists()) {
            return filecurrent.getCanonicalFile();
        }
        for (File d : FileSystem.getPath("plantuml.include.path", true)) {
            if (!d.isDirectory() || !(file = new File(d, nameOrPath)).exists()) continue;
            return file.getCanonicalFile();
        }
        for (File d : FileSystem.getPath("java.class.path", true)) {
            if (!d.isDirectory() || !(file = new File(d, nameOrPath)).exists()) continue;
            return file.getCanonicalFile();
        }
        return filecurrent;
    }

    public static List<File> getPath(String prop, boolean onlyDir) {
        ArrayList<File> result = new ArrayList<File>();
        String paths = System.getProperty(prop);
        if (paths == null) {
            return result;
        }
        paths = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(paths);
        StringTokenizer st = new StringTokenizer(paths, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            File f = new File(st.nextToken());
            if (!f.exists() || onlyDir && !f.isDirectory()) continue;
            result.add(f);
        }
        return result;
    }

    private boolean isAbsolute(String nameOrPath) {
        File f = new File(nameOrPath);
        return f.isAbsolute();
    }

    public void reset() {
        this.setCurrentDir(new File("."));
    }
}

