/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.project3.Subject;

public enum DayOfWeek implements Subject
{
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;


    public static String getRegexString() {
        StringBuilder sb = new StringBuilder();
        for (DayOfWeek day : DayOfWeek.values()) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(day.name().substring(0, 3) + "[a-z]*");
        }
        return sb.toString();
    }

    public static DayOfWeek fromString(String value) {
        value = StringUtils.goUpperCase(value).substring(0, 3);
        for (DayOfWeek day : DayOfWeek.values()) {
            if (!day.name().startsWith(value)) continue;
            return day;
        }
        throw new IllegalArgumentException();
    }

    public DayOfWeek next() {
        return DayOfWeek.values()[(this.ordinal() + 1) % 7];
    }

    public static DayOfWeek fromH(int h) {
        return DayOfWeek.values()[(h + 5) % 7];
    }

    public String shortName() {
        return StringUtils.capitalize(this.name().substring(0, 2));
    }
}

