/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.teoz.Bordered;
import net.sourceforge.plantuml.sequencediagram.teoz.Englobers;
import net.sourceforge.plantuml.sequencediagram.teoz.GroupingTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.sequencediagram.teoz.UGraphicInterceptorTile;
import net.sourceforge.plantuml.sequencediagram.teoz.YPositionedTile;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class MainTile
implements Tile,
Bordered {
    private final double startingY = 8.0;
    private final Real min;
    private final Real max;
    private final boolean isShowFootbox;
    private final List<Tile> tiles = new ArrayList<Tile>();
    private final LivingSpaces livingSpaces;

    public MainTile(SequenceDiagram diagram, Englobers englobers, TileArguments tileArguments) {
        this.livingSpaces = tileArguments.getLivingSpaces();
        ArrayList<Real> min2 = new ArrayList<Real>();
        ArrayList<Real> max2 = new ArrayList<Real>();
        min2.add(tileArguments.getOrigin());
        max2.add(tileArguments.getOrigin());
        if (englobers.size() > 0) {
            min2.add(englobers.getMinX(tileArguments.getStringBounder()));
            max2.add(englobers.getMaxX(tileArguments.getStringBounder()));
        }
        this.tiles.addAll(TileBuilder.buildSeveral(diagram.events().iterator(), tileArguments, null));
        for (Tile tile : this.tiles) {
            min2.add(tile.getMinX(tileArguments.getStringBounder()));
            max2.add(tile.getMaxX(tileArguments.getStringBounder()));
        }
        for (LivingSpace livingSpace : this.livingSpaces.values()) {
            max2.add(livingSpace.getPosD(tileArguments.getStringBounder()));
            max2.add(livingSpace.getPosC2(tileArguments.getStringBounder()));
        }
        this.min = RealUtils.min(min2);
        this.max = RealUtils.max(max2);
        this.isShowFootbox = diagram.isShowFootbox();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        LiveBoxFinder liveBoxFinder = new LiveBoxFinder(stringBounder);
        this.drawUInternal(liveBoxFinder, false);
        UGraphicInterceptorTile interceptor = new UGraphicInterceptorTile(ug, true);
        this.drawUInternal(interceptor, false);
    }

    public void drawForeground(UGraphic ug) {
        UGraphicInterceptorTile interceptor = new UGraphicInterceptorTile(ug, false);
        this.drawUInternal(interceptor, false);
    }

    private double drawUInternal(UGraphic ug, boolean trace) {
        StringBounder stringBounder = ug.getStringBounder();
        ArrayList<YPositionedTile> positionedTiles = new ArrayList<YPositionedTile>();
        double y = GroupingTile.fillPositionelTiles(stringBounder, 8.0, this.tiles, positionedTiles);
        for (YPositionedTile tile : positionedTiles) {
            tile.drawU(ug);
        }
        return y;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        UGraphicInterceptorTile interceptor = new UGraphicInterceptorTile(limitFinder, false);
        double finalY = this.drawUInternal(interceptor, false);
        double result = Math.max(limitFinder.getMinMax().getDimension().getHeight(), finalY) + 10.0;
        return result;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }

    @Override
    public Event getEvent() {
        return null;
    }

    public boolean isShowFootbox() {
        return this.isShowFootbox;
    }

    public LivingSpaces getLivingSpaces() {
        return this.livingSpaces;
    }

    @Override
    public double getBorder1() {
        return this.min.getCurrentValue();
    }

    @Override
    public double getBorder2() {
        return this.max.getCurrentValue();
    }
}

