/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.timingdiagram.TimingStyle;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandRobustConcise
extends SingleLineCommand2<TimingDiagram> {
    public CommandRobustConcise() {
        super(CommandRobustConcise.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandRobustConcise.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("COMPACT", "(compact)"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("TYPE", "(robust|concise)"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("FULL", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("CODE", "([%pLN_.@]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        String compact = arg.get("COMPACT", 0);
        String code = arg.get("CODE", 0);
        String full = arg.get("FULL", 0);
        if (full == null) {
            full = code;
        }
        Stereotype stereotype = null;
        if (arg.get("STEREOTYPE", 0) != null) {
            stereotype = Stereotype.build(arg.get("STEREOTYPE", 0));
        } else if (arg.get("STEREOTYPE2", 0) != null) {
            stereotype = Stereotype.build(arg.get("STEREOTYPE2", 0));
        }
        TimingStyle type = TimingStyle.valueOf(arg.get("TYPE", 0).toUpperCase());
        return diagram.createRobustConcise(code, full, type, compact != null, stereotype);
    }
}

