/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextNote
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextNote(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth() - 1;
        int height = (int)dimensionToUse.getHeight();
        charArea.fillRect(' ', 2, 1, width - 3, height - 2);
        if (this.type == ComponentType.NOTE) {
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawNoteSimpleUnicode(2, 0, width - 2, height);
            } else {
                charArea.drawNoteSimple(2, 0, width - 2, height);
            }
        } else if (this.type == ComponentType.NOTE_BOX) {
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawBoxSimpleUnicode(2, 0, width - 2, height);
            } else {
                charArea.drawBoxSimple(2, 0, width - 2, height);
            }
        }
        charArea.drawStringsLR(this.stringsToDisplay.as(), 3, 1);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 7;
    }
}

