/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageArcCircle
extends AbstractEntityImage {
    private final TextBlock name;
    private final TextBlock stereo;

    public EntityImageArcCircle(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.name = entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.COMPONENT, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.stereo = stereotype == null || stereotype.getLabel(false) == null ? null : Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimName = this.name.calculateDimension(stringBounder);
        Dimension2D dimStereo = this.getStereoDimension(stringBounder);
        return Dimension2DDouble.mergeTB(dimStereo, dimName);
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimStereo = this.getStereoDimension(stringBounder);
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimName = this.name.calculateDimension(stringBounder);
        double nameX = (dimTotal.getWidth() - dimName.getWidth()) / 2.0;
        double nameY = dimStereo.getHeight();
        this.name.drawU(ug.apply(new UTranslate(nameX, nameY)));
        if (this.stereo != null) {
            double stereoX = (dimTotal.getWidth() - dimStereo.getWidth()) / 2.0;
            this.stereo.drawU(ug.apply(new UTranslate(stereoX, 0.0)));
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

