/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.klimt.sprite.SpriteImage;
import net.sourceforge.plantuml.klimt.sprite.SpriteSvg;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.Log;

public class CommandSpriteFile
extends SingleLineCommand2<TitledDiagram> {
    public static final CommandSpriteFile ME = new CommandSpriteFile();

    private CommandSpriteFile() {
        super(CommandSpriteFile.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSpriteFile.class.getName(), RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), new RegexLeaf("NAME", "([-%pLN_]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("FILE", "([^<>%g#]*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram system, LineLocation location, RegexResult arg) {
        Sprite sprite;
        String src = arg.get("FILE", 0);
        try {
            if (src.startsWith("jar:")) {
                String inner = src.substring(4) + ".png";
                InputStream is = SpriteImage.getInternalSprite(inner);
                if (is == null) {
                    return CommandExecutionResult.error("No such internal sprite: " + inner);
                }
                sprite = new SpriteImage(SImageIO.read(is));
            } else if (src.contains("~")) {
                int idx = src.lastIndexOf("~");
                SFile f = FileSystem.getInstance().getFile(src.substring(0, idx));
                if (!f.exists()) {
                    return CommandExecutionResult.error("Cannot read: " + src);
                }
                String name = src.substring(idx + 1);
                sprite = this.getImageFromZip(f, name);
                if (sprite == null) {
                    return CommandExecutionResult.error("Cannot read: " + src);
                }
            } else {
                SFile f = FileSystem.getInstance().getFile(src);
                if (!f.exists()) {
                    return CommandExecutionResult.error("Cannot read: " + src);
                }
                if (this.isSvg(f.getName())) {
                    String tmp = FileUtils.readSvg(f);
                    if (tmp == null) {
                        return CommandExecutionResult.error("Cannot read: " + src);
                    }
                    sprite = new SpriteSvg(tmp);
                } else {
                    BufferedImage tmp = f.readRasterImageFromFile();
                    if (tmp == null) {
                        return CommandExecutionResult.error("Cannot read: " + src);
                    }
                    sprite = new SpriteImage(tmp);
                }
            }
        }
        catch (IOException e) {
            Log.error("Error reading " + src + " " + e);
            return CommandExecutionResult.error("Cannot read: " + src);
        }
        system.addSprite(arg.get("NAME", 0), sprite);
        return CommandExecutionResult.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sprite getImageFromZip(SFile f, String name) throws IOException {
        InputStream tmp = f.openFile();
        if (tmp == null) {
            return null;
        }
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(tmp);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                if (!ze.isDirectory() && fileName.equals(name)) {
                    if (this.isSvg(name)) {
                        SpriteSvg spriteSvg = new SpriteSvg(FileUtils.readSvg(zis));
                        return spriteSvg;
                    }
                    SpriteImage spriteImage = new SpriteImage(SImageIO.read(zis));
                    return spriteImage;
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            if (zis != null) {
                zis.closeEntry();
                zis.close();
            }
        }
        return null;
    }

    private boolean isSvg(String name) {
        return name.toLowerCase().endsWith(".svg");
    }
}

