/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.MyPoint2D;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.Segment;
import net.sourceforge.plantuml.cute.TriangleCornerSimple;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TriangleCorner {
    private final Point2D o;
    private final Point2D a;
    private final Point2D b;
    private final TriangleCornerSimple simple;
    private final UTranslate translateO;
    private final UTranslate translateOreverse;
    private final RotationZoom rotation;
    private final RotationZoom rotationInverse;

    public String toString() {
        return "Corner " + this.o + " a=" + this.a + " b=" + this.b;
    }

    public boolean hasCurvation() {
        return ((MyPoint2D)this.o).hasCurvation();
    }

    public double getCurvation() {
        if (!this.hasCurvation()) {
            throw new IllegalStateException();
        }
        return ((MyPoint2D)this.o).getCurvation(0.0);
    }

    public TriangleCorner(Point2D o, Point2D a, Point2D b) {
        Point2D b3;
        Point2D a3;
        this.o = o;
        this.a = a;
        this.b = b;
        this.translateO = new UTranslate(o);
        this.translateOreverse = this.translateO.reverse();
        Point2D a2 = this.translateOreverse.getTranslated(a);
        Point2D b2 = this.translateOreverse.getTranslated(b);
        if (a2.getX() == 0.0) {
            a3 = a2;
            b3 = b2;
            this.rotation = RotationZoom.none();
            this.rotationInverse = RotationZoom.none();
        } else {
            this.rotation = RotationZoom.builtRotationOnYaxis(a2);
            this.rotationInverse = this.rotation.inverse();
            a3 = this.rotation.getPoint(a2);
            b3 = this.rotation.getPoint(b2);
        }
        this.simple = new TriangleCornerSimple(a3, b3);
    }

    public Point2D getOnSegmentA(double dist) {
        Segment seg = new Segment(this.o, this.a);
        return seg.getFromAtoB(dist);
    }

    public Point2D getOnSegmentB(double dist) {
        Segment seg = new Segment(this.o, this.b);
        return seg.getFromAtoB(dist);
    }

    public Balloon getCenterWithFixedRadius(double radius) {
        Point2D centerSimple = this.simple.getCenterWithFixedRadius(radius);
        return new Balloon(this.rotationInverse.getPoint(this.translateO.getTranslated(centerSimple)), radius);
    }

    private Balloon getBalloonWithFixedY(double y) {
        Balloon result = this.simple.getBalloonWithFixedY(y);
        result = result.rotate(this.rotationInverse);
        result = result.translate(this.translateO);
        return result;
    }

    public Point2D getCornerOrBalloonCenter() {
        if (this.hasCurvation()) {
            return this.getBalloonInside().getCenter();
        }
        return this.getO();
    }

    public double determinant() {
        double ux = this.a.getX() - this.o.getX();
        double uy = this.a.getY() - this.o.getY();
        double vx = this.b.getX() - this.o.getX();
        double vy = this.b.getY() - this.o.getY();
        return ux * vy - uy * vx;
    }

    public Point2D getO() {
        return this.o;
    }

    public Balloon getBalloonInside() {
        if (!this.hasCurvation()) {
            throw new IllegalStateException();
        }
        return this.getBalloonWithFixedY(this.getCurvation());
    }
}

