/*
 * Decompiled with CFR 0.152.
 */
package org.debian.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.debian.security.InvalidKeystorePasswordException;
import org.debian.security.UnableToSaveKeystoreException;

class KeyStoreHandler {
    private String filename;
    private char[] password;
    private KeyStore ks;
    private CertificateFactory certFactory;

    KeyStoreHandler(String filename, char[] password) throws GeneralSecurityException, IOException, InvalidKeystorePasswordException {
        this.filename = filename;
        this.password = password;
        this.certFactory = CertificateFactory.getInstance("X.509");
        this.load();
    }

    public void load() throws GeneralSecurityException, IOException, InvalidKeystorePasswordException {
        KeyStore ks = KeyStore.getInstance("JKS");
        File file = new File(this.filename);
        FileInputStream in = null;
        if (file.canRead()) {
            in = new FileInputStream(file);
        }
        try {
            ks.load(in, this.password);
        }
        catch (IOException e) {
            throw new InvalidKeystorePasswordException("Cannot open Java keystore. Is the password correct?", e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.ks = ks;
    }

    public void save() throws GeneralSecurityException, UnableToSaveKeystoreException {
        try {
            FileOutputStream certOutputFile = new FileOutputStream(this.filename);
            this.ks.store(certOutputFile, this.password);
            certOutputFile.close();
        }
        catch (IOException e) {
            throw new UnableToSaveKeystoreException("There was a problem saving the new Java keystore.", e);
        }
    }

    public void addAlias(String alias, String path) throws KeyStoreException {
        Certificate cert = this.loadCertificate(path);
        if (cert == null) {
            return;
        }
        this.addAlias(alias, cert);
    }

    public void addAlias(String alias, Certificate cert) throws KeyStoreException {
        if (this.contains(alias)) {
            System.out.println("Replacing " + alias);
            this.ks.deleteEntry(alias);
        } else {
            System.out.println("Adding " + alias);
        }
        this.ks.setCertificateEntry(alias, cert);
    }

    public void deleteAlias(String alias) throws GeneralSecurityException {
        if (this.contains(alias)) {
            System.out.println("Removing " + alias);
            this.ks.deleteEntry(alias);
        }
    }

    public boolean contains(String alias) throws KeyStoreException {
        return this.ks.containsAlias(alias);
    }

    private Certificate loadCertificate(String path) {
        Certificate certificate = null;
        try {
            FileInputStream in = new FileInputStream(path);
            certificate = this.certFactory.generateCertificate(in);
            in.close();
        }
        catch (Exception e) {
            System.err.println("Warning: there was a problem reading the certificate file " + path + ". Message:\n  " + e.getMessage());
        }
        return certificate;
    }
}

