/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMargedWest;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidthCentered;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside2;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.ConditionStyle;

class FtileIfLongVertical
extends AbstractFtile {
    private final double ySeparation = 20.0;
    private final double marginy1 = 30.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final Ftile lastDiamond;
    private final Rainbow arrowColor;

    @Override
    public Collection<Ftile> getMyChildren() {
        ArrayList<Ftile> result = new ArrayList<Ftile>(this.tiles);
        result.add(this.tile2);
        return Collections.unmodifiableList(result);
    }

    private FtileIfLongVertical(List<Ftile> diamonds, List<Ftile> tiles, Ftile tile2, Rainbow arrowColor, Ftile lastDiamond) {
        super(tiles.get(0).skinParam());
        if (diamonds.size() != tiles.size()) {
            throw new IllegalArgumentException();
        }
        this.lastDiamond = lastDiamond;
        this.tile2 = tile2;
        this.diamonds = new ArrayList<Ftile>(diamonds);
        this.tiles = new ArrayList<Ftile>(tiles);
        this.arrowColor = arrowColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        for (Ftile tile : this.tiles) {
            result.addAll(tile.getSwimlanes());
        }
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tiles.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HColor backColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> thens, Branch branch2, LinkRendering topInlinkRendering, LinkRendering afterEndwhile, Style styleArrow, Style styleDiamond) {
        int i;
        FontConfiguration fcArrow = styleArrow.getFontConfiguration(ftileFactory.skinParam().getIHtmlColorSet());
        HColor borderColor = styleDiamond.value(PName.LineColor).asColor(ftileFactory.skinParam().getIHtmlColorSet());
        Rainbow arrowColor = Rainbow.build(styleArrow, ftileFactory.skinParam().getIHtmlColorSet());
        ArrayList<Ftile> diamonds = new ArrayList<Ftile>();
        double west = 10.0;
        for (Branch branch : thens) {
            TextBlock tb1 = branch.getDisplayPositive().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            TextBlock tbTest = branch.getLabelTest().create(fcArrow, ftileFactory.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), ftileFactory.skinParam());
            FtileDiamondInside2 diamond = new FtileDiamondInside2(tbTest, branch.skinParam(), backColor, borderColor, swimlane);
            diamond = diamond.withEast(tb1);
            diamonds.add(diamond);
            if (Display.isNull(branch.getInlabel())) continue;
            TextBlock tbInlabel = branch.getInlabel().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            west = Math.max(west, tbInlabel.calculateDimension(ftileFactory.getStringBounder()).getWidth());
        }
        ArrayList<Ftile> tiles = new ArrayList<Ftile>();
        for (Branch branch : thens) {
            tiles.add(new FtileMargedWest(branch.getFtile(), west));
        }
        FtileDiamond ftileDiamond = new FtileDiamond(((Ftile)tiles.get(0)).skinParam(), backColor, borderColor, swimlane);
        FtileMinWidthCentered tile2 = new FtileMinWidthCentered(branch2.getFtile(), 30.0);
        FtileIfLongVertical result = new FtileIfLongVertical(diamonds, tiles, tile2, arrowColor, ftileDiamond);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        for (i = 0; i < thens.size(); ++i) {
            Ftile ftile = (Ftile)tiles.get(i);
            Ftile diam = (Ftile)diamonds.get(i);
            Rainbow color = thens.get(i).getInColor(arrowColor);
            FtileIfLongVertical ftileIfLongVertical = result;
            Objects.requireNonNull(ftileIfLongVertical);
            conns.add(ftileIfLongVertical.new ConnectionVerticalIn(diam, ftile, color == null ? arrowColor : color));
        }
        for (i = 0; i < diamonds.size() - 1; ++i) {
            Branch branch = thens.get(i + 1);
            TextBlock tbInlabel = null;
            if (!Display.isNull(branch.getInlabel())) {
                tbInlabel = branch.getInlabel().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            }
            FtileIfLongVertical ftileIfLongVertical = result;
            Objects.requireNonNull(ftileIfLongVertical);
            conns.add(ftileIfLongVertical.new ConnectionVertical((Ftile)diamonds.get(i), (Ftile)diamonds.get(i + 1), arrowColor, tbInlabel));
        }
        FtileIfLongVertical ftileIfLongVertical = result;
        Objects.requireNonNull(ftileIfLongVertical);
        conns.add(ftileIfLongVertical.new ConnectionThenOut((Ftile)tiles.get(0), arrowColor));
        for (i = 1; i < tiles.size(); ++i) {
            FtileIfLongVertical ftileIfLongVertical2 = result;
            Objects.requireNonNull(ftileIfLongVertical2);
            conns.add(ftileIfLongVertical2.new ConnectionThenOutConnect((Ftile)tiles.get(i), arrowColor));
        }
        Rainbow topInColor = topInlinkRendering.getRainbow(arrowColor);
        FtileIfLongVertical ftileIfLongVertical3 = result;
        Objects.requireNonNull(ftileIfLongVertical3);
        conns.add(ftileIfLongVertical3.new ConnectionIn(topInColor));
        TextBlock tb2 = branch2.getDisplayPositive().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        FtileIfLongVertical ftileIfLongVertical4 = result;
        Objects.requireNonNull(ftileIfLongVertical4);
        conns.add(ftileIfLongVertical4.new ConnectionLastElse(topInColor, tb2));
        FtileIfLongVertical ftileIfLongVertical5 = result;
        Objects.requireNonNull(ftileIfLongVertical5);
        conns.add(ftileIfLongVertical5.new ConnectionLastElseOut(arrowColor));
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (child == this.lastDiamond) {
            return this.getTranslateLastDiamond(stringBounder);
        }
        if (this.tiles.contains(child)) {
            return this.getTranslate1(child, stringBounder);
        }
        if (this.diamonds.contains(child)) {
            return this.getTranslateDiamond(child, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateDiamond(Ftile diamond, StringBounder stringBounder) {
        double allDiamondsWidth = this.allDiamondsWidth(stringBounder);
        int idx = this.diamonds.indexOf(diamond);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        double y1 = this.getTranslateDy(idx, stringBounder);
        return new UTranslate((allDiamondsWidth - diamond.calculateDimension(stringBounder).getWidth()) / 2.0, y1);
    }

    private UTranslate getTranslateLastDiamond(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimLast = this.lastDiamond.calculateDimension(stringBounder);
        double x = (((XDimension2D)dimTotal).getWidth() - dimLast.getWidth()) / 2.0;
        return new UTranslate(x, ((XDimension2D)dimTotal).getHeight() - dimLast.getHeight());
    }

    private UTranslate getTranslate1(Ftile candidat, StringBounder stringBounder) {
        int idx = this.tiles.indexOf(candidat);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        double y1 = this.getTranslateDy(idx, stringBounder);
        FtileGeometry diam = this.diamonds.get(idx).calculateDimension(stringBounder);
        FtileGeometry dim1 = candidat.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        double allDiamondsWidth = this.allDiamondsWidth(stringBounder);
        double x = allDiamondsWidth + (dimTotal.getWidth() - allDiamondsWidth - dim1.getWidth()) / 2.0;
        return new UTranslate(x, y1 + diam.getHeight());
    }

    private double getTranslateDy(int idx, StringBounder stringBounder) {
        double y1 = 30.0;
        for (int i = 0; i < idx; ++i) {
            FtileGeometry dim1 = this.tiles.get(i).calculateDimension(stringBounder);
            FtileGeometry diam = this.diamonds.get(i).calculateDimension(stringBounder);
            y1 += dim1.getHeight() + diam.getHeight() + 20.0;
        }
        return y1;
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        double y1 = this.getTranslateDy(this.tiles.size(), stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        double x = (dimTotal.getWidth() - dim2.getWidth()) / 2.0;
        return new UTranslate(x, y1);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Ftile tile1 : this.tiles) {
            ug.apply(this.getTranslate1(tile1, stringBounder)).draw(tile1);
        }
        for (Ftile diam : this.diamonds) {
            ug.apply(this.getTranslateDiamond(diam, stringBounder)).draw(diam);
        }
        ug.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
        ug.apply(this.getTranslateLastDiamond(stringBounder)).draw(this.lastDiamond);
    }

    private FtileGeometry calculateDimensionInternal(StringBounder stringBounder) {
        double col1 = 0.0;
        double col2 = 0.0;
        double height = 30.0;
        for (int i = 0; i < this.tiles.size(); ++i) {
            FtileGeometry dim1 = this.tiles.get(i).calculateDimension(stringBounder);
            FtileGeometry diamondDim = this.diamonds.get(i).calculateDimension(stringBounder);
            height += diamondDim.getHeight() + dim1.getHeight();
            col1 = Math.max(col1, diamondDim.getWidth());
            col2 = Math.max(col2, dim1.getWidth());
        }
        double width = col1 + col2;
        FtileGeometry result = new FtileGeometry(width, height, width / 2.0, 0.0);
        FtileGeometry dimTile2 = this.tile2.calculateDimension(stringBounder);
        result = result.appendBottom(dimTile2);
        FtileGeometry dimLastDiamond = this.lastDiamond.calculateDimension(stringBounder);
        double lastElseArrowHeight = 40.0;
        result = result.addDim(0.0, 20.0 * (double)this.tiles.size() + 40.0 + dimLastDiamond.getHeight());
        return new FtileGeometry(result, result.getWidth() / 2.0, 0.0);
    }

    private double allDiamondsWidth(StringBounder stringBounder) {
        double width = 0.0;
        for (Ftile diam : this.diamonds) {
            width = Math.max(width, diam.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> all = new ArrayList<Ftile>(this.tiles);
        all.add(this.tile2);
        for (Ftile tmp : all) {
            if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(dimTotal, ((XDimension2D)dimTotal).getWidth() / 2.0, 0.0, ((XDimension2D)dimTotal).getHeight());
        }
        return new FtileGeometry(dimTotal, ((XDimension2D)dimTotal).getWidth() / 2.0, 0.0);
    }

    class ConnectionVerticalIn
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionVerticalIn(Ftile diamond, Ftile tile, Rainbow color) {
            super(diamond, tile);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfLongVertical.this.skinParam(), this.color, FtileIfLongVertical.this.skinParam().arrows().asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            double diamondWidth = ((XDimension2D)dimDiamond1).getWidth();
            return FtileIfLongVertical.this.getTranslateDiamond(this.getFtile1(), stringBounder).getTranslated(new XPoint2D(diamondWidth, ((XDimension2D)dimDiamond1).getHeight() / 2.0));
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            XPoint2D p = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongVertical.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionVertical
    extends AbstractConnection {
        private final Rainbow color;
        private final TextBlock label;

        public ConnectionVertical(Ftile diamond1, Ftile diamond2, Rainbow color, TextBlock label) {
            super(diamond1, diamond2);
            this.color = color;
            this.label = label;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfLongVertical.this.skinParam(), this.color, FtileIfLongVertical.this.skinParam().arrows().asToDown()).withLabel(this.label, VerticalAlignment.CENTER);
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            XPoint2D p = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLongVertical.this.getTranslateFor(this.getFtile1(), stringBounder).getTranslated(p);
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            XPoint2D p = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongVertical.this.getTranslateFor(this.getFtile2(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionThenOut
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionThenOut(Ftile tile1, Rainbow arrowColor) {
            super(tile1, FtileIfLongVertical.this.lastDiamond);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dim1 = this.getFtile1().calculateDimension(stringBounder);
            if (!dim1.hasPointOut()) {
                return;
            }
            XPoint2D p1 = FtileIfLongVertical.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(dim1.getPointOut());
            FtileGeometry dimLastDiamond = this.getFtile2().calculateDimension(stringBounder);
            XPoint2D p2 = FtileIfLongVertical.this.getTranslateLastDiamond(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
            p2 = new UTranslate(dimLastDiamond.getWidth() / 2.0, dimLastDiamond.getHeight() / 2.0).getTranslated(p2);
            FtileGeometry dimTotal = FtileIfLongVertical.this.calculateDimensionInternal(stringBounder);
            Snake snake = Snake.create(FtileIfLongVertical.this.skinParam(), this.arrowColor, FtileIfLongVertical.this.skinParam().arrows().asToLeft());
            snake.addPoint(p1);
            snake.addPoint(p1.getX(), p1.getY() + 15.0);
            snake.addPoint(((XDimension2D)dimTotal).getWidth(), p1.getY() + 15.0);
            snake.addPoint(((XDimension2D)dimTotal).getWidth(), p2.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionThenOutConnect
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionThenOutConnect(Ftile tile1, Rainbow arrowColor) {
            super(tile1, FtileIfLongVertical.this.lastDiamond);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dim1 = this.getFtile1().calculateDimension(stringBounder);
            if (!dim1.hasPointOut()) {
                return;
            }
            XPoint2D p1 = FtileIfLongVertical.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(dim1.getPointOut());
            FtileGeometry dimTotal = FtileIfLongVertical.this.calculateDimensionInternal(stringBounder);
            XPoint2D p2 = new XPoint2D(((XDimension2D)dimTotal).getWidth(), p1.getY() + 15.0);
            Snake snake = Snake.create(FtileIfLongVertical.this.skinParam(), this.arrowColor, FtileIfLongVertical.this.skinParam().arrows().asToRight());
            snake.addPoint(p1);
            snake.addPoint(p1.getX(), p2.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionIn(Rainbow arrowColor) {
            super(null, (Ftile)FtileIfLongVertical.this.diamonds.get(0));
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            UTranslate tr = FtileIfLongVertical.this.getTranslateDiamond(this.getFtile2(), ug.getStringBounder());
            XPoint2D p2 = tr.getTranslated(this.getFtile2().calculateDimension(ug.getStringBounder()).getPointIn());
            Snake snake = Snake.create(FtileIfLongVertical.this.skinParam(), this.arrowColor, FtileIfLongVertical.this.skinParam().arrows().asToDown());
            XPoint2D p1 = FtileIfLongVertical.this.calculateDimensionInternal(ug.getStringBounder()).getPointIn();
            snake.addPoint(p1);
            snake.addPoint(p1.getX(), (p1.getY() + p2.getY()) / 2.0);
            snake.addPoint(p2.getX(), (p1.getY() + p2.getY()) / 2.0);
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionLastElse
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final TextBlock label;

        public ConnectionLastElse(Rainbow arrowColor, TextBlock label) {
            super((Ftile)FtileIfLongVertical.this.diamonds.get(FtileIfLongVertical.this.diamonds.size() - 1), FtileIfLongVertical.this.tile2);
            this.arrowColor = arrowColor;
            this.label = label;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            UTranslate tr1 = FtileIfLongVertical.this.getTranslateDiamond(this.getFtile1(), stringBounder);
            FtileGeometry dimDiamond = this.getFtile1().calculateDimension(stringBounder);
            XPoint2D p1 = tr1.getTranslated(dimDiamond.getPointOut());
            XPoint2D p2 = FtileIfLongVertical.this.getTranslate2(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
            Snake snake = Snake.create(FtileIfLongVertical.this.skinParam(), this.arrowColor, FtileIfLongVertical.this.skinParam().arrows().asToDown()).withLabel(this.label, VerticalAlignment.CENTER);
            snake.addPoint(p1);
            snake.addPoint(p1.getX(), p2.getY() - 15.0);
            snake.addPoint(p2.getX(), p2.getY() - 15.0);
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionLastElseOut(Rainbow arrowColor) {
            super(FtileIfLongVertical.this.tile2, FtileIfLongVertical.this.lastDiamond);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry dim1 = this.getFtile1().calculateDimension(stringBounder);
            if (!dim1.hasPointOut()) {
                return;
            }
            XPoint2D p1 = FtileIfLongVertical.this.getTranslate2(stringBounder).getTranslated(dim1.getPointOut());
            XPoint2D p2 = FtileIfLongVertical.this.getTranslateLastDiamond(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
            Snake snake = Snake.create(FtileIfLongVertical.this.skinParam(), this.arrowColor, FtileIfLongVertical.this.skinParam().arrows().asToDown());
            snake.addPoint(p1);
            snake.addPoint(p1.getX(), p2.getY() - 15.0);
            snake.addPoint(p2.getX(), p2.getY() - 15.0);
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }
}

