/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Bullet
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final int order;

    public Bullet(FontConfiguration fontConfiguration, int order) {
        this.fontConfiguration = fontConfiguration;
        this.order = order;
    }

    private double getWidth(StringBounder stringBounder) {
        Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), "W");
        return dim.getWidth() * (double)(this.order + 1);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.order == 0) {
            this.drawU0(ug);
        } else {
            this.drawU1(ug);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.order == 0) {
            return this.calculateDimension0(stringBounder);
        }
        return this.calculateDimension1(stringBounder);
    }

    private void drawU0(UGraphic ug) {
        HtmlColor color = this.fontConfiguration.getColor();
        ug = ug.apply(new UChangeColor(color)).apply(new UChangeBackColor(color)).apply(new UStroke(0.0));
        ug = ug.apply(new UTranslate(3.0, 0.0));
        ug.draw(new UEllipse(5.0, 5.0));
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return -5.0;
    }

    private Dimension2D calculateDimension0(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidth(stringBounder), 5.0);
    }

    private void drawU1(UGraphic ug) {
        HtmlColor color = this.fontConfiguration.getColor();
        ug = ug.apply(new UChangeColor(color)).apply(new UChangeBackColor(color)).apply(new UStroke(0.0));
        double width = this.getWidth(ug.getStringBounder());
        ug = ug.apply(new UTranslate(width - 5.0, 0.0));
        ug.draw(new URectangle(3.5, 3.5));
    }

    private Dimension2D calculateDimension1(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidth(stringBounder), 3.0);
    }
}

