/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.FontInfo;
import org.scilab.forge.jlatexmath.TeXFormula;

public class CharBox
extends Box {
    private final CharFont cf;
    private final float size;
    private float italic;
    private final char[] arr = new char[1];

    public CharBox(Char c) {
        this.cf = c.getCharFont();
        this.size = c.getMetrics().getSize();
        this.width = c.getWidth();
        this.height = c.getHeight();
        this.depth = c.getDepth();
        this.italic = c.getItalic();
    }

    public void addItalicCorrectionToWidth() {
        this.width += this.italic;
        this.italic = 0.0f;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        this.drawDebug(g2, x, y);
        AffineTransform at = g2.getTransform();
        g2.translate(x, y);
        Font font = FontInfo.getFont(this.cf.fontId);
        if (Math.abs(this.size - TeXFormula.FONT_SCALE_FACTOR) > 1.0E-7f) {
            g2.scale(this.size / TeXFormula.FONT_SCALE_FACTOR, this.size / TeXFormula.FONT_SCALE_FACTOR);
        }
        if (g2.getFont() != font) {
            g2.setFont(font);
        }
        this.arr[0] = this.cf.c;
        g2.drawChars(this.arr, 0, 1, 0, 0);
        g2.setTransform(at);
    }

    @Override
    public int getLastFontId() {
        return this.cf.fontId;
    }

    public String toString() {
        return super.toString() + "=" + this.cf.c;
    }
}

