/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util.geom;

import java.io.Serializable;

public class StrictBounds
implements Serializable,
Cloneable {
    private long x;
    private long y;
    private long width;
    private long height;
    private boolean locked;

    public StrictBounds() {
    }

    public StrictBounds(long l, long l2, long l3, long l4) {
        this.x = l;
        this.y = l2;
        this.width = l3;
        this.height = l4;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public StrictBounds getLockedInstance() {
        if (this.locked) {
            return this;
        }
        StrictBounds strictBounds = (StrictBounds)this.clone();
        strictBounds.locked = true;
        return strictBounds;
    }

    public StrictBounds getUnlockedInstance() {
        StrictBounds strictBounds = (StrictBounds)this.clone();
        strictBounds.locked = false;
        return strictBounds;
    }

    public void setRect(long l, long l2, long l3, long l4) {
        if (this.locked) {
            throw new IllegalStateException("This object is locked");
        }
        this.x = l;
        this.y = l2;
        this.width = l3;
        this.height = l4;
    }

    public long getHeight() {
        return this.height;
    }

    public long getWidth() {
        return this.width;
    }

    public long getX() {
        return this.x;
    }

    public long getY() {
        return this.y;
    }

    public boolean isEmpty() {
        return this.width == 0L || this.height == 0L;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone must always be supported.");
        }
    }

    public boolean contains(long l, long l2) {
        if (l < this.x) {
            return false;
        }
        if (l2 < this.y) {
            return false;
        }
        if (l > this.x + this.width) {
            return false;
        }
        return l2 <= this.y + this.height;
    }

    public static boolean intersects(StrictBounds strictBounds, StrictBounds strictBounds2) {
        double d = strictBounds.getX();
        double d2 = strictBounds.getY();
        double d3 = strictBounds2.getX();
        double d4 = strictBounds2.getWidth();
        double d5 = strictBounds2.getY();
        double d6 = strictBounds2.getHeight();
        return d3 + d4 >= d && d5 + d6 >= d2 && d3 <= d + (double)strictBounds.getWidth() && d5 <= d2 + (double)strictBounds.getHeight();
    }

    public void add(StrictBounds strictBounds) {
        if (this.locked) {
            throw new IllegalStateException("This object is locked");
        }
        long l = Math.min(this.getX(), strictBounds.getX());
        long l2 = Math.min(this.getY(), strictBounds.getY());
        long l3 = Math.max(this.getX() + this.getWidth(), strictBounds.getX() + strictBounds.getWidth());
        long l4 = Math.max(this.getY() + this.getHeight(), strictBounds.getY() + strictBounds.getHeight());
        this.setRect(l, l2, Math.max(0L, l3 - l), Math.max(0L, l4 - l2));
    }

    public StrictBounds createIntersection(StrictBounds strictBounds) {
        long l = Math.max(this.getX(), strictBounds.getX());
        long l2 = Math.max(this.getY(), strictBounds.getY());
        long l3 = Math.min(this.getX() + this.getWidth(), strictBounds.getX() + strictBounds.getWidth());
        long l4 = Math.min(this.getY() + this.getHeight(), strictBounds.getY() + strictBounds.getHeight());
        return new StrictBounds(l, l2, Math.max(0L, l3 - l), Math.max(0L, l4 - l2));
    }

    public static boolean contains(StrictBounds strictBounds, StrictBounds strictBounds2) {
        long l = strictBounds.getX();
        long l2 = strictBounds.getY();
        long l3 = strictBounds2.getX();
        long l4 = strictBounds2.getY();
        long l5 = strictBounds2.getWidth();
        long l6 = strictBounds2.getHeight();
        return l3 >= l && l4 >= l2 && l3 + l5 <= l + strictBounds.getWidth() && l4 + l6 <= l2 + strictBounds.getHeight();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StrictBounds)) {
            return false;
        }
        StrictBounds strictBounds = (StrictBounds)object;
        if (this.height != strictBounds.height) {
            return false;
        }
        if (this.width != strictBounds.width) {
            return false;
        }
        if (this.x != strictBounds.x) {
            return false;
        }
        return this.y == strictBounds.y;
    }

    public int hashCode() {
        int n = (int)(this.x ^ this.x >>> 32);
        n = 29 * n + (int)(this.y ^ this.y >>> 32);
        n = 29 * n + (int)(this.width ^ this.width >>> 32);
        n = 29 * n + (int)(this.height ^ this.height >>> 32);
        return n;
    }

    public String toString() {
        return new StringBuffer().append("org.jfree.report.util.geom.StrictBounds{").append("x=").append(this.x).append(", y=").append(this.y).append(", width=").append(this.width).append(", height=").append(this.height).append('}').toString();
    }

    public StrictBounds createUnion(StrictBounds strictBounds) {
        long l = Math.min(this.getX(), strictBounds.getX());
        long l2 = Math.min(this.getY(), strictBounds.getY());
        long l3 = Math.max(this.getX() + this.getWidth(), strictBounds.getX() + strictBounds.getWidth()) - l;
        long l4 = Math.max(this.getY() + this.getHeight(), strictBounds.getY() + strictBounds.getHeight()) - l2;
        return new StrictBounds(l, l2, l3, l4);
    }
}

