/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.DatabaseManager;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.Grid;
import org.hsqldb.util.Tree;
import org.hsqldb.util.ZaurusConnectionDialog;
import org.hsqldb.util.ZaurusEditor;

public class ZaurusDatabaseManager
extends DatabaseManager
implements ActionListener,
WindowListener,
KeyListener {
    Button butTree;
    Button butCommand;
    Button butResult;
    Button butEditor;
    Panel pCard;
    CardLayout layoutCard;
    ZaurusEditor eEditor;
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defQuery;
    static String defDirectory;
    static String defDatabase;
    static int defWidth;
    static int defHeight;
    static int defLocX;
    static int defLocY;

    @Override
    public void connect(Connection connection) {
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.cConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.refreshTree();
    }

    public static void main(String[] stringArray) {
        bMustExit = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-driver") && i + 1 < stringArray.length) {
                defDriver = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-url") && i + 1 < stringArray.length) {
                defURL = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-width") && i + 1 < stringArray.length) {
                ++i;
                try {
                    defWidth = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-height") && i + 1 < stringArray.length) {
                ++i;
                try {
                    defHeight = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-locx") && i + 1 < stringArray.length) {
                ++i;
                try {
                    defLocX = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-locy") && i + 1 < stringArray.length) {
                ++i;
                try {
                    defLocY = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-user") && i + 1 < stringArray.length) {
                defUser = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-password") && i + 1 < stringArray.length) {
                defPassword = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-query") && i + 1 < stringArray.length) {
                defQuery = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-defDirectory") && i + 1 < stringArray.length) {
                defDirectory = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-database") && i + 1 < stringArray.length) {
                defDatabase = stringArray[++i];
                continue;
            }
            ZaurusDatabaseManager.showUsage();
            return;
        }
        ZaurusDatabaseManager zaurusDatabaseManager = new ZaurusDatabaseManager();
        zaurusDatabaseManager.main();
        Connection connection = null;
        if (defDriver != null && defURL != null || defDatabase != null) {
            if (defDatabase != null) {
                defDriver = "org.hsqldb.jdbcDriver";
                defURL = "jdbc:hsqldb:" + defDatabase;
                defUser = "sa";
                defPassword = "";
            }
            try {
                Class.forName(defDriver).newInstance();
                connection = DriverManager.getConnection(defURL, defUser, defPassword);
            }
            catch (Exception exception) {
                System.out.println("No connection for " + defDriver + " at " + defURL);
                exception.printStackTrace();
            }
        } else {
            connection = ZaurusConnectionDialog.createConnection(zaurusDatabaseManager.fMain, "Connect", new Insets(defWidth, defHeight, defLocX, defLocY));
        }
        if (connection == null) {
            return;
        }
        zaurusDatabaseManager.connect(connection);
    }

    private static void showUsage() {
        System.out.println("Usage: java org.hsqldb.util.ZaurusDatabaseManager [options]");
        System.out.println("where options could be:");
        System.out.println("If the next two options are set, the specified connection will be used:");
        System.out.println("   -driver dr");
        System.out.println("   -url address");
        System.out.println("-user name");
        System.out.println("-password passw");
        System.out.println("Alternative the database argument is used,");
        System.out.println("and the hsqldb Driver Standalone is choosen for user 'sa'.");
        System.out.println("-database db");
        System.out.println("-query qu                   the query qu will be read during initialization");
        System.out.println("-defaultDirectory defdir    default dir for the file open dialog");
        System.out.println("If the next two options are set, the frame will be set to the specified values:");
        System.out.println("   -width width");
        System.out.println("   -height height");
        System.out.println("-locX positon left ");
        System.out.println("-locY positon top ");
        System.out.println("");
        System.out.println("1. Example: java org.hsqldb.util.ZaurusDatabaseManager +");
        System.out.println("  -driver 'org.hsqldb.jdbcDriver' +");
        System.out.println("  -url 'jdbc:hsqldb:test'");
        System.out.println("2. Example: java org.hsqldb.util.ZaurusDatabaseManager +");
        System.out.println("  -database 'test'");
    }

    @Override
    public void main() {
        this.fMain = new Frame("HSQLDB Database Manager for Zaurus");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        MenuBar menuBar = new MenuBar();
        String[] stringArray = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(menuBar, "File", stringArray);
        String[] stringArray2 = new String[]{"-Refresh Tree", "--", "-View Tree", "-View Command", "-View Result", "-View Editor", "--", "-Results in Grid", "-Results in Text"};
        this.addMenu(menuBar, "View", stringArray2);
        String[] stringArray3 = new String[]{"-SELECT", "-INSERT", "-UPDATE", "-DELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-SCRIPT", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(menuBar, "SQL", stringArray3);
        Menu menu = new Menu("Recent");
        this.mRecent = new Menu("Recent");
        menuBar.add(this.mRecent);
        String[] stringArray4 = new String[]{"-AutoCommit on", "-AutoCommit off", "-Commit", "-Rollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(menuBar, "Options", stringArray4);
        String[] stringArray5 = new String[]{"-Show HTML-Help in browser"};
        this.addMenu(menuBar, "?", stringArray5);
        this.fMain.setMenuBar(menuBar);
        this.fMain.setSize(defWidth, defHeight);
        this.fMain.add("Center", this);
        this.initGUI();
        this.sRecent = new String[24];
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        if (dimension.width > 640) {
            this.fMain.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else if (defWidth > 0 && defHeight > 0) {
            this.fMain.setLocation(defLocX, defLocY);
            this.fMain.setSize(defWidth, defHeight);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(dimension);
        }
        this.fMain.show();
        if (defQuery != null) {
            this.txtCommand.setText(DatabaseManagerCommon.readFile(defQuery));
        }
        this.txtCommand.requestFocus();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && (keyEvent.isControlDown() || keyEvent.isShiftDown())) {
            keyEvent.consume();
            this.execute();
            this.layoutCard.show(this.pCard, "result");
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof MenuItem) {
            string = ((MenuItem)actionEvent.getSource()).getLabel();
        }
        if (string.equals("Execute")) {
            this.execute();
            this.layoutCard.show(this.pCard, "result");
        } else if (string.equals("Tree")) {
            this.layoutCard.show(this.pCard, "tree");
        } else if (string.equals("Command")) {
            this.layoutCard.show(this.pCard, "command");
        } else if (string.equals("Result")) {
            this.layoutCard.show(this.pCard, "result");
        } else if (string.equals("Editor")) {
            this.layoutCard.show(this.pCard, "editor");
        } else if (string.equals("Exit")) {
            this.windowClosing(null);
        } else if (string.equals("Logging on")) {
            JavaSystem.setLogToSystem((boolean)true);
        } else if (string.equals("Logging off")) {
            JavaSystem.setLogToSystem((boolean)false);
        } else if (string.equals("Refresh Tree")) {
            this.refreshTree();
            this.layoutCard.show(this.pCard, "tree");
        } else if (string.startsWith("#")) {
            int n = Integer.parseInt(string.substring(1));
            this.txtCommand.setText(this.sRecent[n]);
        } else if (string.equals("Connect...")) {
            this.connect(ZaurusConnectionDialog.createConnection(this.fMain, "Connect", new Insets(defWidth, defHeight, defLocX, defLocY)));
            this.refreshTree();
            this.layoutCard.show(this.pCard, "tree");
        } else if (string.equals("View Tree")) {
            this.layoutCard.show(this.pCard, "tree");
        } else if (string.equals("View Command")) {
            this.layoutCard.show(this.pCard, "command");
        } else if (string.equals("View Result")) {
            this.layoutCard.show(this.pCard, "result");
        } else if (string.equals("View Editor")) {
            this.layoutCard.show(this.pCard, "editor");
        } else if (string.equals("Results in Grid")) {
            this.iResult = 0;
            this.pResult.removeAll();
            this.pResult.add("Center", this.gResult);
            this.pResult.doLayout();
            this.layoutCard.show(this.pCard, "result");
        } else if (string.equals("Open Script...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Open Script", 0);
            if (defDirectory != null) {
                fileDialog.setDirectory(defDirectory);
            }
            fileDialog.show();
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                this.txtCommand.setText(DatabaseManagerCommon.readFile(fileDialog.getDirectory() + string2));
            }
            this.layoutCard.show(this.pCard, "command");
        } else if (string.equals("Save Script...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Save Script", 1);
            if (defDirectory != null) {
                fileDialog.setDirectory(defDirectory);
            }
            fileDialog.show();
            String string3 = fileDialog.getFile();
            if (string3 != null) {
                DatabaseManagerCommon.writeFile(fileDialog.getDirectory() + string3, this.txtCommand.getText());
            }
        } else if (string.equals("Save Result...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Save Result", 1);
            if (defDirectory != null) {
                fileDialog.setDirectory(defDirectory);
            }
            fileDialog.show();
            String string4 = fileDialog.getFile();
            if (string4 != null) {
                this.showResultInText();
                DatabaseManagerCommon.writeFile(fileDialog.getDirectory() + string4, this.txtResult.getText());
            }
        } else if (string.equals("Results in Text")) {
            this.iResult = 1;
            this.pResult.removeAll();
            this.pResult.add("Center", this.txtResult);
            this.pResult.doLayout();
            this.showResultInText();
            this.layoutCard.show(this.pCard, "result");
        } else if (string.equals("AutoCommit on")) {
            try {
                this.cConn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("AutoCommit off")) {
            try {
                this.cConn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Commit")) {
            try {
                this.cConn.commit();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Insert test data")) {
            this.insertTestData();
            this.layoutCard.show(this.pCard, "result");
        } else if (string.equals("Rollback")) {
            try {
                this.cConn.rollback();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Disable MaxRows")) {
            try {
                this.sStatement.setMaxRows(0);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Set MaxRows to 100")) {
            try {
                this.sStatement.setMaxRows(100);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("SELECT")) {
            this.showHelp(DatabaseManagerCommon.selectHelp);
        } else if (string.equals("INSERT")) {
            this.showHelp(DatabaseManagerCommon.insertHelp);
        } else if (string.equals("UPDATE")) {
            this.showHelp(DatabaseManagerCommon.updateHelp);
        } else if (string.equals("DELETE")) {
            this.showHelp(DatabaseManagerCommon.deleteHelp);
        } else if (string.equals("CREATE TABLE")) {
            this.showHelp(DatabaseManagerCommon.createTableHelp);
        } else if (string.equals("DROP TABLE")) {
            this.showHelp(DatabaseManagerCommon.dropTableHelp);
        } else if (string.equals("CREATE INDEX")) {
            this.showHelp(DatabaseManagerCommon.createIndexHelp);
        } else if (string.equals("DROP INDEX")) {
            this.showHelp(DatabaseManagerCommon.dropIndexHelp);
        } else if (string.equals("CHECKPOINT")) {
            this.showHelp(DatabaseManagerCommon.checkpointHelp);
        } else if (string.equals("SCRIPT")) {
            this.showHelp(DatabaseManagerCommon.scriptHelp);
        } else if (string.equals("SHUTDOWN")) {
            this.showHelp(DatabaseManagerCommon.shutdownHelp);
        } else if (string.equals("SET")) {
            this.showHelp(DatabaseManagerCommon.setHelp);
        } else if (string.equals("Test Script")) {
            this.showHelp(DatabaseManagerCommon.testHelp);
        } else if (string.equals("Show HTML-Help in browser")) {
            try {
                System.out.println("Starting Opera on index.html");
                Runtime.getRuntime().exec(new String[]{"opera", "/home/QtPalmtop/help/html/hsqldb/index.html"});
            }
            catch (IOException iOException) {
                System.out.println("A problem with Opera occured.");
            }
        }
    }

    private void initGUI() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.pCard = new Panel();
        this.layoutCard = new CardLayout(2, 2);
        this.pCard.setLayout(this.layoutCard);
        this.butTree = new Button("Tree");
        this.butCommand = new Button("Command");
        this.butResult = new Button("Result");
        this.butEditor = new Button("Editor");
        this.butTree.addActionListener(this);
        this.butCommand.addActionListener(this);
        this.butResult.addActionListener(this);
        this.butEditor.addActionListener(this);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 4, 8, 8));
        panel3.add(this.butTree);
        panel3.add(this.butCommand);
        panel3.add(this.butResult);
        panel3.add(this.butEditor);
        this.pResult = new Panel();
        panel.setLayout(new BorderLayout());
        panel2.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.addKeyListener(this);
        this.txtResult = new TextArea(20, 40);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new Button("Execute");
        this.butExecute.addActionListener(this);
        panel2.add("South", this.butExecute);
        panel2.add("Center", this.txtCommand);
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        this.pResult.add("Center", this.gResult);
        this.tTree = new Tree();
        this.tTree.setMinimumSize(new Dimension(200, 100));
        this.gResult.setMinimumSize(new Dimension(200, 300));
        this.eEditor = new ZaurusEditor();
        this.pCard.add("tree", this.tTree);
        this.pCard.add("command", panel2);
        this.pCard.add("result", this.pResult);
        this.pCard.add("editor", this.eEditor);
        this.fMain.add("Center", this.pCard);
        this.fMain.add("North", panel3);
        this.doLayout();
        this.fMain.pack();
    }

    @Override
    protected void refreshTree() {
        super.refreshTree();
        this.eEditor.refresh(this.cConn);
    }

    static {
        defWidth = 237;
        defHeight = 259;
        defLocX = 0;
        defLocY = 0;
    }
}

