/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer.methods;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class PageFormatSerializer
implements SerializeMethod {
    @Override
    public void writeObject(Object o, ObjectOutputStream out) throws IOException {
        PageFormat pf = (PageFormat)o;
        out.writeObject(this.resolvePageFormat(pf));
    }

    @Override
    public Object readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object[] pageFormatResolve = (Object[])in.readObject();
        return this.createPageFormat(pageFormatResolve);
    }

    @Override
    public Class getObjectClass() {
        return PageFormat.class;
    }

    private Object[] resolvePageFormat(PageFormat format) {
        Integer orientation = new Integer(format.getOrientation());
        Paper p = format.getPaper();
        float[] fdim = new float[]{(float)p.getWidth(), (float)p.getHeight()};
        float[] rect = new float[]{(float)p.getImageableX(), (float)p.getImageableY(), (float)p.getImageableWidth(), (float)p.getImageableHeight()};
        return new Object[]{orientation, fdim, rect};
    }

    private PageFormat createPageFormat(Object[] data) {
        Integer orientation = (Integer)data[0];
        float[] dim = (float[])data[1];
        float[] rect = (float[])data[2];
        Paper p = new Paper();
        p.setSize(dim[0], dim[1]);
        p.setImageableArea(rect[0], rect[1], rect[2], rect[3]);
        PageFormat format = new PageFormat();
        format.setPaper(p);
        format.setOrientation(orientation);
        return format;
    }
}

