/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.sprite;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.AsciiEncoderFinalZeros;
import net.sourceforge.plantuml.code.ByteArray;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.code.CompressionZopfliZlib;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.PairInt;
import net.sourceforge.plantuml.code.SpiralOnRectangle;
import net.sourceforge.plantuml.klimt.color.ColorUtils;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.klimt.sprite.SpriteMonochrome;
import net.sourceforge.plantuml.log.Logme;

public final class SpriteGrayLevel
extends Enum<SpriteGrayLevel> {
    public static final /* enum */ SpriteGrayLevel GRAY_16 = new SpriteGrayLevel(16);
    public static final /* enum */ SpriteGrayLevel GRAY_8 = new SpriteGrayLevel(8);
    public static final /* enum */ SpriteGrayLevel GRAY_4 = new SpriteGrayLevel(4);
    private final int nbColor;
    private static final /* synthetic */ SpriteGrayLevel[] $VALUES;

    public static SpriteGrayLevel[] values() {
        return (SpriteGrayLevel[])$VALUES.clone();
    }

    public static SpriteGrayLevel valueOf(String name) {
        return Enum.valueOf(SpriteGrayLevel.class, name);
    }

    private SpriteGrayLevel(int nbColor) {
        this.nbColor = nbColor;
    }

    public static SpriteGrayLevel get(int n) {
        if (n == 4) {
            return GRAY_4;
        }
        if (n == 8) {
            return GRAY_8;
        }
        if (n == 16) {
            return GRAY_16;
        }
        throw new UnsupportedOperationException();
    }

    public int getNbColor() {
        return this.nbColor;
    }

    public List<String> encode(BufferedImage img) {
        if (this == GRAY_16) {
            return this.encode16(img);
        }
        if (this == GRAY_8) {
            return this.encode8(img);
        }
        if (this == GRAY_4) {
            return this.encode4(img);
        }
        throw new UnsupportedOperationException();
    }

    private List<String> encode16(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        ArrayList<String> result = new ArrayList<String>();
        for (int y = 0; y < height; ++y) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < width; ++x) {
                int level = this.getGrayOn16(img, x, y);
                char code = "0123456789ABCDEF".charAt(level);
                sb.append(code);
            }
            result.add(sb.toString());
        }
        return Collections.unmodifiableList(result);
    }

    private List<String> encode8(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        ArrayList<String> result = new ArrayList<String>();
        for (int y = 0; y < height; y += 2) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < width; ++x) {
                int level1 = this.getGrayOn16(img, x, y) / 2;
                assert (level1 >= 0 && level1 <= 7);
                int level2 = this.getGrayOn16(img, x, y + 1) / 2;
                assert (level2 >= 0 && level2 <= 7);
                int v = level1 * 8 + level2;
                sb.append(AsciiEncoder.encode6bit((byte)v));
            }
            result.add(sb.toString());
        }
        return Collections.unmodifiableList(result);
    }

    private List<String> encode4(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        ArrayList<String> result = new ArrayList<String>();
        for (int y = 0; y < height; y += 3) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < width; ++x) {
                int level1 = this.getGrayOn16(img, x, y) / 4;
                assert (level1 >= 0 && level1 <= 3);
                int level2 = this.getGrayOn16(img, x, y + 1) / 4;
                assert (level2 >= 0 && level2 <= 3);
                int level3 = this.getGrayOn16(img, x, y + 2) / 4;
                assert (level3 >= 0 && level3 <= 3);
                int v = level1 * 16 + level2 * 4 + level3;
                sb.append(AsciiEncoder.encode6bit((byte)v));
            }
            result.add(sb.toString());
        }
        return Collections.unmodifiableList(result);
    }

    private int getGrayOn16(BufferedImage img, int x, int y) {
        if (x >= img.getWidth()) {
            return 0;
        }
        if (y >= img.getHeight()) {
            return 0;
        }
        Color g = ColorUtils.getGrayScaleColor(new Color(img.getRGB(x, y)));
        int gray = 255 - g.getRed();
        return gray / 16;
    }

    public Sprite buildSprite(int width, int height, List<String> strings) {
        if (this == GRAY_16) {
            return this.buildSprite16(strings);
        }
        if (this == GRAY_8) {
            return this.buildSprite8(width, height, strings);
        }
        if (this == GRAY_4) {
            return this.buildSprite4(width, height, strings);
        }
        throw new UnsupportedOperationException(this.toString());
    }

    private Sprite buildSprite16(List<String> strings) {
        SpriteMonochrome result = new SpriteMonochrome(strings.get(0).length(), strings.size(), 16);
        for (int col = 0; col < result.getWidth(); ++col) {
            for (int line = 0; line < result.getHeight(); ++line) {
                char c;
                String sline = strings.get(line);
                if (col >= sline.length() || (c = strings.get(line).charAt(col)) == '0') continue;
                int x = Character.digit(c, 16);
                result.setGray(col, line, x);
            }
        }
        return result;
    }

    private Sprite buildSprite8(int width, int height, List<String> strings) {
        SpriteMonochrome result = new SpriteMonochrome(width, height, 8);
        for (int col = 0; col < result.getWidth(); ++col) {
            for (int line = 0; line < strings.size(); ++line) {
                if (col >= strings.get(line).length()) continue;
                int v = AsciiEncoder.decode6bit(strings.get(line).charAt(col));
                int w1 = v / 8;
                int w2 = v % 8;
                result.setGray(col, line * 2, w1);
                result.setGray(col, line * 2 + 1, w2);
            }
        }
        return result;
    }

    private Sprite buildSprite4(int width, int height, List<String> strings) {
        SpriteMonochrome result = new SpriteMonochrome(width, height, 4);
        for (int col = 0; col < result.getWidth(); ++col) {
            for (int line = 0; line < strings.size(); ++line) {
                if (col >= strings.get(line).length()) continue;
                int v = AsciiEncoder.decode6bit(strings.get(line).charAt(col));
                int w1 = v / 16;
                int w2 = (v %= 16) / 4;
                int w3 = v % 4;
                result.setGray(col, line * 3, w1);
                result.setGray(col, line * 3 + 1, w2);
                result.setGray(col, line * 3 + 2, w3);
            }
        }
        return result;
    }

    public List<String> encodeZ(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        byte[] raw = new byte[width * height];
        int cpt = 0;
        int coef = 16 / this.nbColor;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = this.getGrayOn16(img, x, y) / coef;
                raw[cpt++] = (byte)color;
            }
        }
        byte[] comp = new CompressionZopfliZlib().compress(raw);
        return this.cut(new AsciiEncoderFinalZeros().encode(comp));
    }

    private List<String> encodeZSpiral(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        byte[] raw = new byte[width * height];
        int coef = 16 / this.nbColor;
        SpiralOnRectangle spiral = new SpiralOnRectangle(width, height);
        for (int cpt = 0; cpt < width * height; ++cpt) {
            PairInt pt = spiral.nextPoint();
            int color = this.getGrayOn16(img, pt.getX(), pt.getY()) / coef;
            raw[cpt] = (byte)color;
        }
        byte[] comp = new CompressionZopfliZlib().compress(raw);
        return this.cut(new AsciiEncoderFinalZeros().encode(comp));
    }

    private List<String> cut(String s) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < s.length(); i += 120) {
            int j = Math.min(i + 120, s.length());
            result.add(s.substring(i, j));
        }
        return Collections.unmodifiableList(result);
    }

    public Sprite buildSpriteZ(int width, int height, String compressed) {
        byte[] comp = new AsciiEncoder().decode(compressed);
        try {
            ByteArray img = new CompressionZlib().decompress(comp);
            SpriteMonochrome result = new SpriteMonochrome(width, height, this.nbColor);
            int cpt = 0;
            for (int line = 0; line < result.getHeight(); ++line) {
                for (int col = 0; col < result.getWidth(); ++col) {
                    result.setGray(col, line, img.getByteAt(cpt++));
                }
            }
            return result;
        }
        catch (NoPlantumlCompressionException e) {
            Logme.error(e);
            return null;
        }
    }

    static {
        $VALUES = new SpriteGrayLevel[]{GRAY_16, GRAY_8, GRAY_4};
    }
}

