/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

public class Stripe
implements Comparable<Stripe> {
    private final double x1;
    private final double x2;
    private final double value;

    public String toString() {
        return "" + (int)this.x1 + "->" + (int)this.x2 + " (" + (int)this.value + ")";
    }

    public Stripe(double x1, double x2, double value) {
        if (x2 <= x1) {
            System.err.println("x1=" + x1);
            System.err.println("x2=" + x2);
            throw new IllegalArgumentException();
        }
        this.x1 = x1;
        this.x2 = x2;
        this.value = value;
    }

    public boolean contains(double x) {
        return x >= this.x1 && x <= this.x2;
    }

    @Override
    public int compareTo(Stripe other) {
        return (int)Math.signum(this.x1 - other.x1);
    }

    public double getValue() {
        return this.value;
    }

    public final double getStart() {
        return this.x1;
    }

    public final double getEnd() {
        return this.x2;
    }
}

