/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.Today;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.lang.ComplementDate;
import net.sourceforge.plantuml.project.lang.ComplementInColors;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class SubjectToday
implements Subject<GanttDiagram> {
    public static final Subject<GanttDiagram> ME = new SubjectToday();

    private SubjectToday() {
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("today"));
    }

    @Override
    public Failable<Today> getMe(GanttDiagram project, RegexResult arg) {
        return Failable.ok(new Today());
    }

    @Override
    public Collection<? extends SentenceSimple<GanttDiagram>> getSentences() {
        return Arrays.asList(new InColor(), new IsDate());
    }

    class IsDate
    extends SentenceSimple<GanttDiagram> {
        public IsDate() {
            super(SubjectToday.this, Verbs.is, ComplementDate.any());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Day date = (Day)complement;
            return project.setToday(date);
        }
    }

    class InColor
    extends SentenceSimple<GanttDiagram> {
        public InColor() {
            super(SubjectToday.this, Verbs.isColored, new ComplementInColors());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Today task = (Today)subject;
            CenterBorderColor colors = (CenterBorderColor)complement;
            project.setTodayColors(colors);
            return CommandExecutionResult.ok();
        }
    }
}

