/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.SpecificBackcolorable;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.WithStyle;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.LineLocation;

public class Participant
implements SpecificBackcolorable,
WithStyle {
    private final String code;
    private Display display;
    private final ParticipantType type;
    private int initialLife = 0;
    private Stereotype stereotype;
    private boolean stereotypePositionTop;
    private final Set<EntityPortion> hiddenPortions;
    private final int order;
    private final StyleBuilder styleBuilder;
    private final LineLocation location;
    private final String uid;
    private List<Fashion> liveBackcolors = new ArrayList<Fashion>();
    private Colors colors = Colors.empty();
    private Url url;

    @Override
    public StyleSignatureBasic getStyleSignature() {
        return this.type.getStyleSignature().addClickable(this.getUrl());
    }

    @Override
    public Style[] getUsedStyles() {
        StyleSignature signature = this.getStyleSignature().withTOBECHANGED(this.stereotype);
        Style tmp = signature.getMergedStyle(this.styleBuilder);
        tmp = tmp.eventuallyOverride(this.getColors());
        Style stereo = this.getStyleSignature().forStereotypeItself(this.stereotype).getMergedStyle(this.styleBuilder);
        if (tmp != null) {
            stereo = tmp.mergeWith(stereo, MergeStrategy.OVERWRITE_EXISTING_VALUE);
        }
        return new Style[]{tmp, stereo};
    }

    public Participant(LineLocation location, ParticipantType type, String code, Display display, Set<EntityPortion> hiddenPortions, int order, StyleBuilder styleBuilder, String uid) {
        this.location = location;
        this.uid = uid;
        this.hiddenPortions = hiddenPortions;
        this.styleBuilder = styleBuilder;
        this.order = order;
        this.code = Objects.requireNonNull(code);
        if (code.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display) || display.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.type = Objects.requireNonNull(type);
        this.display = display;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public Display getDisplay(boolean underlined) {
        Display result;
        Display display = result = underlined ? this.display.underlined() : this.display;
        if (this.stereotype != null && !this.hiddenPortions.contains((Object)EntityPortion.STEREOTYPE)) {
            result = this.stereotypePositionTop ? result.addFirst(this.stereotype) : result.add(this.stereotype);
        }
        return result;
    }

    public ParticipantType getType() {
        return this.type;
    }

    public final void setStereotype(Stereotype stereotype, boolean stereotypePositionTop) {
        if (this.stereotype != null) {
            throw new IllegalStateException();
        }
        this.stereotype = Objects.requireNonNull(stereotype);
        this.stereotypePositionTop = stereotypePositionTop;
    }

    public final int getInitialLife() {
        return this.initialLife;
    }

    public final void incInitialLife(Fashion colors) {
        ++this.initialLife;
        this.liveBackcolors.add(colors);
    }

    public Fashion getLiveSpecificBackColors(int which) {
        return this.liveBackcolors.get(which);
    }

    @Override
    public Colors getColors() {
        return this.colors;
    }

    public void setSpecificColorTOBEREMOVED(ColorType type, HColor color) {
        if (color != null) {
            this.colors = this.colors.add(type, color);
        }
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public int getOrder() {
        return this.order;
    }

    public LineLocation getLocation() {
        return this.location;
    }

    public UGroup groupTypeTail(Pragma pragma) {
        UGroup group = new UGroup();
        group.put(UGroupType.CLASS, "participant participant-tail");
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.code);
        group.put(UGroupType.DATA_PARTICIPANT, this.code);
        group.put(UGroupType.DATA_ENTITY_UID, this.uid);
        if (pragma.isTrue(PragmaKey.SVGNEWDATA)) {
            group.put(UGroupType.DATA_UID, this.uid + "-tail");
        }
        return group;
    }

    public UGroup groupTypeHead(Pragma pragma) {
        UGroup group = new UGroup();
        group.put(UGroupType.CLASS, "participant participant-head");
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.code);
        group.put(UGroupType.DATA_PARTICIPANT, this.code);
        group.put(UGroupType.DATA_ENTITY_UID, this.uid);
        if (pragma.isTrue(PragmaKey.SVGNEWDATA)) {
            group.put(UGroupType.DATA_UID, this.uid + "-head");
        }
        return group;
    }

    public UGroup groupTypeLifeline(Pragma pragma) {
        UGroup group = new UGroup();
        if (pragma.isTrue(PragmaKey.SVGNEWDATA)) {
            group.put(UGroupType.CLASS, "participant-lifeline");
            group.put(UGroupType.DATA_UID, this.uid + "-lifeline");
            group.put(UGroupType.DATA_QUALIFIED_NAME, this.code);
            group.put(UGroupType.DATA_PARTICIPANT, this.code);
            group.put(UGroupType.DATA_ENTITY_UID, this.uid);
        }
        return group;
    }

    public String getUid() {
        return this.uid;
    }
}

